/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.message;

import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.exe.message.AbstractMessageHandler;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.command.ICommandExecutor;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.def.Task;

public abstract class AbstractMessageEmitter
extends AbstractMessageHandler {
    private static final long serialVersionUID = 1L;
    protected String send;
    private Map<? extends Serializable, ? extends Serializable> map = null;
    private static final Logger LOGGER = Logger.getLogger(AbstractMessageEmitter.class);

    protected AbstractMessageEmitter() {
    }

    protected void start(ExecutionContext context) {
        WorkflowMessage request = this.createRequest(context);
        WorkflowMessage response = this.doSend(request, context);
        this.copy(response, context);
        this.validate(response);
        ICommandExecutor executor = (ICommandExecutor)ServiceRegistry.getDefault().lookup(ICommandExecutor.class);
        executor.execute(response);
    }

    protected WorkflowMessage doSend(WorkflowMessage request, ExecutionContext context) {
        Resource resource = this.getResource(context);
        Token token = context.getToken();
        Node node = context.getNode();
        this.saveRequest(request, token, node, resource);
        IDestination destination = (IDestination)DeviceTypeUtil.createDevice((Resource)resource);
        LOGGER.info((Object)("[Process] " + token + " calling " + resource + " (" + destination + ") [" + this.send + "]"));
        WorkflowMessage response = null;
        try {
            IRoutingService service = RoutingServiceFactory.newInstance().createRoutingService();
            response = service.send(request, Arrays.asList(destination));
            response.setKey(request.getKey());
        }
        catch (CommunicationException e) {
            try {
                throw new ActionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.logResourceFailure(response, context);
                throw throwable;
            }
        }
        this.logResourceFailure(response, context);
        this.saveResponse(response, token, node, resource);
        return response;
    }

    protected WorkflowMessage createRequest(ExecutionContext context) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)this.send, (ExecutionContext)context);
        Map<String, Object> parameters = this.getProcessParameters(context);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            LOGGER.debug((Object)("Global variable " + key + " ,value " + value + " in process " + context.getProcessInstance()));
            if (value == null) continue;
            message.putValue(key, value);
        }
        if (this.map != null) {
            for (Map.Entry<Object, Object> entry : this.map.entrySet()) {
                message.putValue(entry.getKey().toString(), entry.getValue().toString());
                LOGGER.debug((Object)("Local variable " + entry.getKey() + " value " + entry.getValue()));
            }
        }
        return message;
    }

    protected void validate(WorkflowMessage response) {
        if (response.getType() == WorkflowMessage.MessageType.nack) {
            ActionException e = null;
            Object o = response.getParameterValue("error-message");
            e = o instanceof String ? new ActionException(ErrorCategory.NACK.name(), (Throwable)new Exception((String)o)) : new ActionException(ErrorCategory.NACK.name());
            e.setProperty("message", (Object)response);
            throw e;
        }
    }

    protected void saveRequest(WorkflowMessage request, Token token, Node node, Resource resource) {
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowMessageLogEvent(token, node, false, resource, request));
    }

    protected void saveResponse(WorkflowMessage response, Token token, Node node, Resource resource) {
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowMessageLogEvent(token, node, true, resource, response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getProcessParameters(ExecutionContext context) {
        HashMap<String, Object> processParameters = new HashMap<String, Object>();
        Collection<TaskVariable> variables = this.getVariables(context);
        WorkflowProcess process = (WorkflowProcess)context.getProcessInstance();
        process.lock();
        try {
            for (TaskVariable variable : variables) {
                if (!variable.isReadable()) continue;
                String name = variable.getVariableName();
                if (StringUtils.isBlank((String)name)) {
                    LOGGER.warn((Object)("Invalid Variable: type " + variable.getDatatype() + ", name " + variable.getVariableName()));
                }
                Object value = context.getVariable(name);
                if (variable.getMappedName() != null) {
                    name = variable.getMappedName();
                }
                if (value == null) {
                    LOGGER.warn((Object)("Set a empty variable " + name + ", value " + value));
                }
                processParameters.put(name, value);
            }
        }
        finally {
            process.unlock();
        }
        return processParameters;
    }

    protected Collection<TaskVariable> getVariables(ExecutionContext context) {
        Task task = context.getTask();
        if (task != null) {
            return task.getTaskController().getVariableAccesses();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(WorkflowMessage response, ExecutionContext context) {
        Collection<TaskVariable> variables = this.getVariables(context);
        WorkflowProcess process = (WorkflowProcess)context.getToken().getProcessInstance();
        process.lock();
        try {
            WorkflowMessage.MessageType messageType = response.getType();
            for (TaskVariable variable : variables) {
                if (!variable.isWritable() || messageType.equals((Object)WorkflowMessage.MessageType.nack) && !this.isVariableInResponseOrCommand(response, variable)) continue;
                String name = variable.getVariableName();
                Object value = this.getParameterValue(response, variable, name);
                this.setContextVariable(context, variable, name, value);
            }
        }
        finally {
            process.unlock();
        }
    }

    private boolean isVariableInResponseOrCommand(WorkflowMessage response, TaskVariable variable) {
        WPCLCommand command = response.getCommand();
        String variableMappedName = variable.getMappedName();
        return response.getParameters().containsKey(variableMappedName) || command != null && command.getParameters().containsKey(variableMappedName);
    }

    private Object getParameterValue(WorkflowMessage response, TaskVariable variable, String name) {
        Object value = response.getParameterValue(variable.getMappedName());
        if (value == null && response.getCommand() != null) {
            value = response.getCommand().getParameterValue(variable.getMappedName());
        }
        LOGGER.debug((Object)("Writing variable " + name + " value " + value));
        if (value == null) {
            LOGGER.warn((Object)("Set a empty variable " + name + ", value " + value));
        }
        return value;
    }
}

