/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.message;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IIncomingMessageService;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.exe.message.AbstractMessageHandler;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.taskmgmt.def.Task;

public abstract class AbstractMessageReceiver
extends AbstractMessageHandler {
    private static final long serialVersionUID = 1L;
    protected String receive;
    private static final Logger LOGGER = Logger.getLogger(AbstractMessageReceiver.class);

    protected AbstractMessageReceiver() {
    }

    protected void start(ExecutionContext context) {
        WorkflowMessage response = this.receive(context);
        this.logResourceFailure(response, context);
        this.validate(response);
        this.copy(response, context);
    }

    protected WorkflowMessage receive(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        IIncomingMessageService service = (IIncomingMessageService)ServiceRegistry.getDefault().lookup(IIncomingMessageService.class);
        long start = System.currentTimeMillis();
        WorkflowMessage message = service.takeMessage((Token)token);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Time taken to IIncomingMessageService.takeMessage() - time:" + (System.currentTimeMillis() - start) + " token:" + token.getId()));
        }
        LOGGER.info((Object)(token + " received async response: " + message.getMessageUID()));
        return message;
    }

    protected void validate(WorkflowMessage response) {
        if (response.getType() == WorkflowMessage.MessageType.nack) {
            ActionException e = null;
            Object o = response.getParameterValue("error-message");
            e = o instanceof String ? new ActionException(ErrorCategory.NACK.name(), (Throwable)new Exception((String)o)) : new ActionException(ErrorCategory.NACK.name());
            e.setProperty("message", (Object)response);
            throw e;
        }
    }

    protected Collection<TaskVariable> getVariables(ExecutionContext context) {
        ArrayList<TaskVariable> variables = new ArrayList<TaskVariable>();
        TaskNode node = (TaskNode)context.getToken().getNode();
        Set tasks = node.getTasks();
        if (tasks != null && !tasks.isEmpty()) {
            return ((Task)tasks.iterator().next()).getTaskController().getVariableAccesses();
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(WorkflowMessage response, ExecutionContext context) {
        Collection<TaskVariable> variables = this.getVariables(context);
        WorkflowProcess process = (WorkflowProcess)context.getToken().getProcessInstance();
        process.lock();
        try {
            for (TaskVariable variable : variables) {
                if (!variable.isWritable()) continue;
                String name = variable.getVariableName();
                Object value = response.getParameterValue(variable.getMappedName());
                if (value == null) {
                    value = response.getCommand().getParameterValue(variable.getMappedName());
                }
                LOGGER.debug((Object)("Writing variable " + name + " value " + value));
                this.setContextVariable(context, variable, name, value);
            }
        }
        finally {
            process.unlock();
        }
    }
}

