/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.log.hibernate.ProcessLogHDAO;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.jbpm.logging.log.ProcessLog;

public class LogSyncCallable
implements Callable<Long> {
    private SessionFactory factory;
    private List<ProcessLog> logs;
    private int threadNum;
    private static final Logger LOGGER = Logger.getLogger(LogSyncCallable.class);

    public LogSyncCallable(SessionFactory factory, List<ProcessLog> logs, int threadNum) {
        if (logs == null) {
            throw new IllegalArgumentException();
        }
        this.factory = factory;
        this.logs = logs;
        this.threadNum = threadNum;
    }

    @Override
    public Long call() throws Exception {
        Long t = System.currentTimeMillis();
        this.setIdsToZero();
        this.write();
        Long delta = (System.currentTimeMillis() - t) / 1000L;
        LOGGER.debug((Object)("Elapsed time " + delta + "s"));
        return this.threadNum;
    }

    private void setIdsToZero() {
        for (ProcessLog log : this.logs) {
            this.setId(log, 0L);
        }
    }

    private void setId(ProcessLog processLog, Long value) {
        try {
            Field field = ProcessLog.class.getDeclaredField("id");
            field.setAccessible(true);
            field.set(processLog, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void write() throws Exception {
        try {
            ProcessLogHDAO dao = new ProcessLogHDAO(this.factory.openSession());
            dao.create(this.logs);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

