/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.entities.ProcessQueuedPerResourceLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.file.LogFileNames;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;

public class Deserializer {
    private String name;
    private InputStream is;

    public Deserializer(File file) {
        this.name = file.getName();
        try {
            this.is = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public Deserializer(String name, InputStream is) {
        this.name = name;
        this.is = is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessLog deserialize() {
        if (this.is == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Object> fields = this.read(this.is);
        try {
            if (fields.isEmpty()) {
                ProcessLog processLog = null;
                return processLog;
            }
            if (this.name.endsWith("-messageLog")) {
                MessageLog messageLog = this.messageLog(fields);
                return messageLog;
            }
            if (this.name.endsWith("-resourceLog")) {
                ProcessStatusPerResourceLog processStatusPerResourceLog = this.resourceLog(fields);
                return processStatusPerResourceLog;
            }
            NodeLog nodeLog = this.nodeLog(fields);
            return nodeLog;
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException iOException) {}
            this.is = null;
        }
    }

    private NodeLog nodeLog(Map<String, Object> fields) {
        Long id = (Long)fields.get("id");
        Long startTime = (Long)fields.get("startTime");
        Long endTime = (Long)fields.get("endTime");
        Integer nodeId = (Integer)fields.get("nodeId");
        NodeLog log = new NodeLog(new Node(String.valueOf(nodeId)), new Date(startTime), new Date(endTime));
        this.setId((ProcessLog)log, id);
        log.setToken(this.getToken(LogFileNames.getTokenId(this.name)));
        return log;
    }

    private ProcessStatusPerResourceLog resourceLog(Map<String, Object> fields) {
        ProcessStatusPerResourceLog log = null;
        log = fields.get("queued") != null && Boolean.TRUE.equals(fields.get("queued")) ? new ProcessQueuedPerResourceLog() : new ProcessStatusPerResourceLog();
        if (this.hasField(fields, "tokenId")) {
            log.setTokenId(this.parseLong(fields, "tokenId"));
        }
        log.setNodeId(this.parseLong(fields, "nodeId"));
        log.setResourceGroupId(this.parseLong(fields, "resourceGroupId"));
        log.setResourceId(this.parseLong(fields, "resourceId"));
        log.setStartTime(this.parseDate(fields, "startTime"));
        log.setEndTime(this.parseDate(fields, "endTime"));
        log.setOperationalStatus(ProcessStatus.valueOf((String)((String)fields.get("operationalStatus"))));
        log.setAdminStatus(ProcessStatus.valueOf((String)((String)fields.get("adminStatus"))));
        if (this.hasField(fields, "id")) {
            this.setId(log, this.parseLong(fields, "id"));
        } else {
            this.setId(log, this.parseLong(fields, "endTime"));
        }
        return log;
    }

    private MessageLog messageLog(Map<String, Object> fields) {
        WorkflowMessageLog log = new WorkflowMessageLog();
        log.setMessageUID((String)fields.get("messageUID"));
        log.setMessageType((String)fields.get("messageType"));
        log.setMessageName((String)fields.get("messageName"));
        log.setMessage((String)fields.get("message"));
        log.setIncoming((Boolean)fields.get("incoming"));
        log.setTimestamp(new Date((Long)fields.get("timestamp")));
        log.setResource(fields.get("resourceId") != null && !"".equals(fields.get("resourceId")) ? new Resource(new Long(fields.get("resourceId").toString()).longValue()) : null);
        log.setNode(new Node(fields.get("nodeId").toString()));
        log.setToken(this.getToken(this.parseLong(fields, "tokenId")));
        log.setId((Long)fields.get("id"));
        return new MessageLog(log);
    }

    private void setId(ProcessLog processLog, Long value) {
        try {
            Field field = ProcessLog.class.getDeclaredField("id");
            field.setAccessible(true);
            field.set(processLog, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Token getToken(long id) {
        Token token = new Token();
        try {
            Field field = token.getClass().getDeclaredField("id");
            field.setAccessible(true);
            field.set(token, id);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        return token;
    }

    private boolean hasField(Map<String, Object> fields, String field) {
        return fields.containsKey(field);
    }

    private Date parseDate(Map<String, Object> fields, String field) {
        return new Date(this.parseLong(fields, field));
    }

    private Long parseLong(Map<String, Object> fields, String field) {
        return Long.valueOf(fields.get(field).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> read(InputStream is) {
        Map<String, Object> deserialized;
        block12: {
            deserialized = new HashMap<String, Object>();
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(is);
                ObjectMapper mapper = new ObjectMapper();
                deserialized = (Map)mapper.readValue((InputStream)in, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            }
            catch (Exception e) {
                if (in == null) break block12;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return deserialized;
    }
}

