/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.log.file.Deserializer;
import com.tandbergtv.workflow.log.file.FileLogReader;
import com.tandbergtv.workflow.log.file.LogReaderFilenameFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.jbpm.logging.log.ProcessLog;

public class ZipUtil {
    public static final String EXTENSION = ".zip";
    private static final int NO_DATAS = 0;
    private static final Logger LOGGER = Logger.getLogger(ZipUtil.class);

    private ZipUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int count(File zip, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds) {
        if (zip.length() == 0L) {
            return 0;
        }
        try (ZipFile zf = new ZipFile(zip);){
            ArrayList<ZipEntry> zipFiles = Collections.list(zf.entries());
            List<ZipEntry> zipEntryList = ZipUtil.filterFileName(FileLogReader.getSimpleNameList(types), nodeIds, zipFiles);
            int n = zipEntryList.size();
            return n;
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)("Failed to count logs from [" + zip.getName() + "]"), (Throwable)ioe);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ProcessLog> read(File zip) {
        if (zip.length() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<ProcessLog> list = new ArrayList<ProcessLog>();
        try (ZipFile zf = new ZipFile(zip);){
            for (ZipEntry zipEntry : Collections.list(zf.entries())) {
                InputStream is = zf.getInputStream(zipEntry);
                ProcessLog obj = new Deserializer(zipEntry.getName(), is).deserialize();
                if (obj != null) {
                    list.add(obj);
                }
                is.close();
            }
            ArrayList<ProcessLog> arrayList = list;
            return arrayList;
        }
        catch (IOException ex) {
            LOGGER.warn((Object)("Failed to read logs from [" + zip.getName() + "]"), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ProcessLog> read(File zip, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds, int start, int count, boolean descending) {
        if (zip.length() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<ProcessLog> list = new ArrayList<ProcessLog>();
        try (ZipFile zf = new ZipFile(zip);){
            List<ZipEntry> zipEntryList = ZipUtil.filterFileName(FileLogReader.getSimpleNameList(types), nodeIds, Collections.list(zf.entries()));
            ZipUtil.sort(zipEntryList, descending);
            int end = zipEntryList.size() - start < count ? zipEntryList.size() : start + count;
            for (ZipEntry entry : zipEntryList.subList(start, end)) {
                InputStream is = zf.getInputStream(entry);
                ProcessLog log = new Deserializer(entry.getName(), is).deserialize();
                if (log != null) {
                    list.add(log);
                }
                is.close();
            }
            ArrayList<ProcessLog> arrayList = list;
            return arrayList;
        }
        catch (IOException ex) {
            LOGGER.warn((Object)("Failed to read logs from [" + zip.getName() + "]"), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public static String getZipFileName(File dir) {
        return dir.getAbsolutePath() + File.separator + dir.getName() + EXTENSION;
    }

    private static List<ZipEntry> filterFileName(List<String> typeNames, Set<Long> nodeIds, List<ZipEntry> zipEntries) {
        ArrayList<ZipEntry> zipEntryList = new ArrayList<ZipEntry>();
        for (ZipEntry entry : zipEntries) {
            Pattern pattern = Pattern.compile(LogReaderFilenameFilter.getLogReaderFilenameRegex(typeNames), 2);
            Matcher matcher = pattern.matcher(entry.getName());
            while (matcher.find()) {
                if (!nodeIds.contains(Long.parseLong(matcher.group(1)))) continue;
                zipEntryList.add(entry);
            }
        }
        return zipEntryList;
    }

    private static void sort(List<ZipEntry> zipEntries, boolean descending) {
        if (descending) {
            Collections.sort(zipEntries, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry file1, ZipEntry file2) {
                    return file2.getName().compareTo(file1.getName());
                }
            });
        } else {
            Collections.sort(zipEntries, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry file1, ZipEntry file2) {
                    return file1.getName().compareTo(file2.getName());
                }
            });
        }
    }
}

