/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.ratelimiter;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.process.ratelimiter.IActiveWorkOrderMonitor;
import com.tandbergtv.workflow.process.ratelimiter.IOperatingSystemInfo;
import com.tandbergtv.workflow.process.ratelimiter.IRateLimiter;
import com.tandbergtv.workflow.process.ratelimiter.IRateLimiterFactory;
import com.tandbergtv.workflow.process.ratelimiter.OperatingSystemInfoSunJMXImpl;
import com.tandbergtv.workflow.process.ratelimiter.RateLimiterProviderLoader;
import com.tandbergtv.workflow.process.ratelimiter.SimpleRateLimiterImpl;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RateLimiterFactory
implements IRateLimiterFactory,
Service {
    private static final Logger LOGGER = Logger.getLogger(RateLimiterFactory.class);
    public static final int DEFAULT_ACTIVE_WO_THRESHOLD = 256;
    public static final int DEFAULT_ACTIVE_WO_RATIO_THRESHOLD = 70;
    public static final int DEFAULT_CPU_LOAD_THRESHOLD = 95;
    private static IRateLimiterFactory instance = new RateLimiterFactory();
    private volatile IRateLimiter rateLimiter;
    private IActiveWorkOrderMonitor activeWorkOrderMonitor;
    private static final String SERVICE_NAME = "RateLimiter Factory";
    private IOperatingSystemInfo osInfoBean;

    private RateLimiterFactory() {
    }

    public static IRateLimiterFactory getInstance() {
        return instance;
    }

    public void start() {
        if (this.rateLimiter == null) {
            this.initRateLimiterPlugin();
        }
    }

    public void stop() {
        if (this.osInfoBean != null) {
            this.osInfoBean.close();
        }
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public IRateLimiter create() {
        if (this.rateLimiter == null) {
            this.initRateLimiterPlugin();
        }
        return this.rateLimiter;
    }

    private void initRateLimiterPlugin() {
        this.rateLimiter = this.loadRateLimiterPlugin();
        this.updateThresHolds(256, 70.0, 95);
        HashMap<Class, Object> context = new HashMap<Class, Object>();
        context.put(IActiveWorkOrderMonitor.class, this.getActiveWOMonitor());
        this.osInfoBean = this.loadOSInfoPlugin();
        context.put(IOperatingSystemInfo.class, this.osInfoBean);
        this.rateLimiter.setContext(context);
    }

    private IRateLimiter loadRateLimiterPlugin() {
        IRateLimiter plugin = null;
        try {
            plugin = new RateLimiterProviderLoader().createRatelimterPlugin();
        }
        catch (Exception e) {
            LOGGER.info((Object)"Failed to load customized Ratelimiter Plugin from plugin folder:", (Throwable)e);
        }
        if (plugin == null) {
            plugin = new SimpleRateLimiterImpl();
            LOGGER.info((Object)("Cannot find the customized Ratelimiter Plugin, use the built-in default one:" + plugin.getClass().getName()));
        }
        return plugin;
    }

    private IOperatingSystemInfo loadOSInfoPlugin() {
        String className = System.getProperty("cms.OperatingSystemInfoBean");
        IOperatingSystemInfo info = (IOperatingSystemInfo)this.loadClass("IOperatingSystemInfo", className);
        return info == null ? new OperatingSystemInfoSunJMXImpl() : info;
    }

    private Object loadClass(String interfaceName, String className) {
        if (StringUtils.isNotBlank((String)className)) {
            try {
                Class<?> clazz = Class.forName(className);
                return clazz.newInstance();
            }
            catch (Exception e) {
                String errMsg = "Failed to instantiate the " + interfaceName + " Implementation: " + className;
                LOGGER.error((Object)errMsg, (Throwable)e);
            }
        }
        return null;
    }

    private IActiveWorkOrderMonitor getActiveWOMonitor() {
        if (this.activeWorkOrderMonitor == null) {
            this.activeWorkOrderMonitor = ServiceLookup.lookupActiveWOMonitor();
        }
        return this.activeWorkOrderMonitor;
    }

    public void setActiveWorkOrderMonitor(IActiveWorkOrderMonitor activeWorkOrderMonitor) {
        this.activeWorkOrderMonitor = activeWorkOrderMonitor;
    }

    public void updateThresHolds(Integer concurrency, double concurrencyRatio, Integer cpuLoad) {
        HashMap<String, Number> thresholds = new HashMap<String, Number>();
        thresholds.put("ratelimiter.WOConcurrency.threshold", concurrency);
        thresholds.put("ratelimiter.WOConcurrency.ratio.threshold", concurrencyRatio);
        thresholds.put("rateLimiter.cpuload.threshold", cpuLoad);
        this.rateLimiter.setThresholds(thresholds);
    }
}

