/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.settings;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.producer.IArchiveMessageProducer;
import com.tandbergtv.workflow.message.util.StringUtils;
import com.tandbergtv.workflow.settings.ISettingUpdateListenter;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArchiveMessageProducerSettingUpdateListener
implements ISettingUpdateListenter {
    private static final Logger LOGGER = Logger.getLogger(ArchiveMessageProducerSettingUpdateListener.class);
    public static final String CLEANUP_APPLICATION_PATH = "com.tandbergtv.workflow.workordercleanup";
    public static final String RETRY_MESSAGE_TTL_KEY = "producer.retryMessageTtl";

    @Override
    public String getPath() {
        return CLEANUP_APPLICATION_PATH;
    }

    @Override
    public void changed(Map<String, String> setting) {
        this.update(setting);
    }

    private void update(Map<String, String> settings) {
        String retryMessageTtlStr = settings.get(RETRY_MESSAGE_TTL_KEY);
        if (StringUtils.isNotBlank((String)retryMessageTtlStr)) {
            IArchiveMessageProducer archiveMessageProducer = (IArchiveMessageProducer)ServiceRegistry.getDefault().lookup(IArchiveMessageProducer.class);
            long retryMessageTtl = Long.valueOf(retryMessageTtlStr);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("update ArchiveMessageProducer retryMessageTtl=" + retryMessageTtl));
            }
            archiveMessageProducer.setRetryMessageTtl(retryMessageTtl);
        }
    }
}

