/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.settings;

import com.tandbergtv.workflow.core.util.DateFormatter;
import com.tandbergtv.workflow.settings.ISettingUpdateListenter;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DateFormatUpdateListener
implements ISettingUpdateListenter {
    private static final Logger LOGGER = Logger.getLogger(DateFormatUpdateListener.class);
    public static final String NEPTUNE_DATE_TIME_PATH = "com.ericsson.cms.neptune.datetime";

    @Override
    public String getPath() {
        return NEPTUNE_DATE_TIME_PATH;
    }

    @Override
    public void changed(Map<String, String> setting) {
        String dateFormat = setting.get("global_date_format");
        String timeFormat = setting.get("global_time_format");
        if (StringUtils.isEmpty((String)dateFormat) || StringUtils.isEmpty((String)timeFormat)) {
            LOGGER.warn((Object)("Get global date format configration failed, the global_date_format =" + dateFormat + "and the global_time_format = " + timeFormat));
            return;
        }
        LOGGER.debug((Object)("Update Workflow standard date format: " + dateFormat + " " + timeFormat));
        DateFormatter.setStandardDisplayDateFormat((String)(dateFormat + " " + timeFormat));
    }
}

