/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.settings;

import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.settings.ISettingUpdateListenter;
import java.util.Map;
import org.springframework.util.Assert;

public class LicenseSettingUpdateListener
implements ISettingUpdateListenter {
    @Override
    public String getPath() {
        return "WF_LICENSE_SETTING";
    }

    @Override
    public void changed(Map<String, String> setting) {
        Integer limit = this.getLicenseMaxCreateRate(setting);
        IProcessManagerService service = (IProcessManagerService)ServiceLookup.findService(IProcessManagerService.class, (long)5000L, (long)500L);
        Assert.notNull((Object)service, (String)"Cannot find the IProcessManagerService Plugin");
        service.setLicenseCreatedLimit(limit.intValue());
    }

    private Integer getLicenseMaxCreateRate(Map<String, String> setting) {
        return Configuration.toInteger((String)setting.get("ingest.thruput"), (int)Integer.MAX_VALUE);
    }
}

