/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.settings;

import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.message.producer.MessageProducer;
import com.tandbergtv.workflow.settings.ISettingUpdateListenter;
import java.util.Map;
import org.springframework.util.Assert;

public class RabbitMqSettingUpdateListener
implements ISettingUpdateListenter {
    private static final String WORKFLOW_APPLICATION_PATH = "com.tandbergtv.workflow.application";
    private static final String PRODUCER_TIMEOUT_NAME = "rabbitmq.producer.timeout";

    @Override
    public String getPath() {
        return WORKFLOW_APPLICATION_PATH;
    }

    @Override
    public void changed(Map<String, String> setting) {
        Integer timeOut = this.getProducerTimeOut(setting);
        MessageProducer service = (MessageProducer)ServiceLookup.findService(MessageProducer.class, (long)5000L, (long)500L);
        Assert.notNull((Object)service, (String)"Cannot find the MessageProducer service");
        service.setWaitForConfirmMilli(timeOut.intValue());
    }

    private Integer getProducerTimeOut(Map<String, String> setting) {
        return Configuration.toInteger((String)setting.get(PRODUCER_TIMEOUT_NAME), (int)Integer.MAX_VALUE);
    }
}

