/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.settings;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.settings.ISettingUpdateListenter;
import com.tandbergtv.workflow.util.resource.InternalResourceService;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSystemIdUpdateListener
implements ISettingUpdateListenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceSystemIdUpdateListener.class);
    private static final String WORKFLOW_APPLICATION_PATH = "com.tandbergtv.workflow.application";
    private static final String RESOURCE_TYPE_IDS = "com.tandbergtv.workflow.resource.systemids";

    @Override
    public String getPath() {
        return WORKFLOW_APPLICATION_PATH;
    }

    @Override
    public void changed(Map<String, String> setting) {
        InternalResourceService service = (InternalResourceService)ServiceRegistry.getDefault().lookup(InternalResourceService.class);
        String resourceTypeIds = setting.get(RESOURCE_TYPE_IDS);
        if (StringUtils.isEmpty((String)resourceTypeIds)) {
            LOGGER.warn("Get resource type ids config failed, the RESOURCE_TYPE_IDS = {}", (Object)resourceTypeIds);
            return;
        }
        LOGGER.debug("Update RESOURCE_TYPE_IDS config {}", (Object)resourceTypeIds);
        service.resetResourceTypes(resourceTypeIds);
    }
}

