/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.settings;

import com.ericsson.cms.neptune.rabbitmq.workflow.IRabbitMQDeclarer;
import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.message.producer.IWorkOrderByPassingExchangeRebindingService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class WorkOrderByPassingExchangeRebindingService
implements IWorkOrderByPassingExchangeRebindingService,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkOrderByPassingExchangeRebindingService.class);
    private static final String EXCHANGE_BINDING_SERVICE = "RabbitMQ-Exchange-Binding";
    private List<String> byPassFilters = new ArrayList<String>();
    private volatile boolean bindingInited = false;
    private RabbitTemplate rabbitTemplate;
    private Scheduler<Void> scheduler;

    public WorkOrderByPassingExchangeRebindingService(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    public String getServiceName() {
        return EXCHANGE_BINDING_SERVICE;
    }

    public void start() {
        this.scheduler = new Scheduler(EXCHANGE_BINDING_SERVICE, 2, 2);
    }

    public void updateExchangeBinding(List<ComponentType> components) {
        List<String> newByPassFilters = this.getFilters(components);
        if (this.isFilterChanged(newByPassFilters) || !this.bindingInited) {
            try {
                if (ServiceLookup.findClusterService().isMaster()) {
                    this.scheduler.schedule(() -> this.update(newByPassFilters));
                }
                this.bindingInited = true;
            }
            catch (Exception e) {
                LOGGER.error("Failed to create binding for bypass message", (Throwable)e);
            }
        }
    }

    private Void update(List<String> newByPassFilters) {
        List<String> allComponents = this.getAllComponentNames();
        List<String> byPassComponents = newByPassFilters;
        try {
            this.rabbitTemplate.execute(channel -> {
                if (this.isNotEmpty(allComponents)) {
                    for (String name : allComponents) {
                        channel.queueBind(IRabbitMQDeclarer.QUEUE_NAME, IRabbitMQDeclarer.EXCHANGE_NAME, name);
                        channel.queueUnbind(IRabbitMQDeclarer.BYPASS_QUEUE_NAME, IRabbitMQDeclarer.EXCHANGE_NAME, name);
                    }
                }
                if (this.isNotEmpty(byPassComponents)) {
                    for (String name : byPassComponents) {
                        channel.queueBind(IRabbitMQDeclarer.BYPASS_QUEUE_NAME, IRabbitMQDeclarer.EXCHANGE_NAME, name);
                        channel.queueUnbind(IRabbitMQDeclarer.QUEUE_NAME, IRabbitMQDeclarer.EXCHANGE_NAME, name);
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to create binding for component type", (Throwable)e);
        }
        this.byPassFilters.clear();
        this.byPassFilters.addAll(newByPassFilters);
        return null;
    }

    private boolean isNotEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    private List<String> getAllComponentNames() {
        return this.getFilters(Lists.newArrayList((Object[])ComponentType.values()));
    }

    private List<String> getFilters(List<ComponentType> components) {
        ArrayList filters = Lists.newArrayList();
        for (ComponentType componentType : components) {
            filters.add(componentType.toString());
        }
        return filters;
    }

    private boolean isFilterChanged(List<String> filters) {
        boolean isSame = this.byPassFilters.containsAll(filters) && filters.containsAll(this.byPassFilters);
        return !isSame;
    }

    public void stop() {
        this.scheduler.stop();
    }
}

