/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class ClientExtensionClassLoader
extends ClassLoader {
    private static final Logger LOGGER = Logger.getLogger(ClientExtensionClassLoader.class);
    private String dir;

    public ClientExtensionClassLoader(String dir, ClassLoader parent) {
        super(parent);
        this.dir = dir;
    }

    @Override
    protected URL findResource(String name) {
        LOGGER.debug((Object)("Loading resource " + name + " from " + this.dir));
        try {
            return new File(this.dir + File.separator + name).toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOGGER.warn((Object)("Invalid path to resource: " + name), (Throwable)e);
            return null;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.dir == null || this.dir.trim().equals("")) {
            String errorMessage = "Invalid directory. | Dir: [" + this.dir + "]";
            LOGGER.error((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        if (!new File(this.dir.trim()).isDirectory()) {
            String errorMessage = "Not a directory or Directory does not exist. | Dir: [" + this.dir + "]";
            LOGGER.error((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        this.dir = this.dir.trim();
        byte[] data = this.getClassData(this.dir, name);
        if (data.length < 1) {
            throw new ClassNotFoundException(name);
        }
        Class<?> c = this.defineClass(name, data, 0, data.length);
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    private byte[] getClassData(String dir, String className) {
        className = className.replace('.', '/') + ".class";
        LOGGER.debug((Object)("Dir: " + dir + " | Class: " + className));
        byte[] data = new byte[]{};
        File[] jarFiles = this.getJarFiles(dir);
        if (jarFiles == null) {
            LOGGER.warn((Object)("Dir: " + dir + " does not exist or No files with extension \".jar\" found in the directory"));
            return data;
        }
        JarFile jf = null;
        for (File jarFile : jarFiles) {
            LOGGER.debug((Object)("Examining file: " + jarFile));
            try {
                jf = new JarFile(jarFile);
            }
            catch (IOException e) {
                LOGGER.warn((Object)("Ignoring file: " + jarFile), (Throwable)e);
                continue;
            }
            LOGGER.debug((Object)("Jar File Name is: " + jf.getName()));
            JarEntry jarEntry = jf.getJarEntry(className);
            if (jarEntry == null) continue;
            long size = jarEntry.getSize();
            if (size == -1L) {
                LOGGER.error((Object)("Size not obtainable | Jar File Name: " + jf.getName() + " | Jar File Entry: " + jarEntry));
                this.closeJarFile(jf);
                return data;
            }
            LOGGER.debug((Object)("Jar File Entry: " + jarEntry + " | Size: " + size));
            try {
                data = this.getBytes(jf.getInputStream(jarEntry), size);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error in getting data from jar entry. Jar File Name: " + jf.getName() + " | Jar File Entry: " + jarEntry), (Throwable)e);
            }
            this.closeJarFile(jf);
            return data;
        }
        return data;
    }

    private void closeJarFile(JarFile jf) {
        if (jf != null) {
            try {
                jf.close();
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Close JarFile failed", (Throwable)e);
            }
        }
    }

    private File[] getJarFiles(String dir) {
        File f = new File(dir);
        return f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
    }

    private byte[] getBytes(InputStream is, long size) throws IOException {
        if (size > Integer.MAX_VALUE) {
            LOGGER.error((Object)"File Too Big | Size of the file is larger than Integer.MAX_VALUE [2147483647]");
            return new byte[0];
        }
        byte[] buffer = new byte[(int)size];
        new DataInputStream(is).readFully(buffer);
        return buffer;
    }
}

