/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import com.tandbergtv.neptune.file.FolderMonitor;
import com.tandbergtv.neptune.file.Watcher;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.ClientExtensionClassLoader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class ExtensionClassLoaderUtil {
    private static volatile ClientExtensionClassLoader clientExtensionClassLoader;
    private static ReentrantReadWriteLock lock;
    private static Logger log;
    private static FolderMonitor folderMonitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> loadClass(String className) throws Exception {
        ClassLoader loader = ExtensionClassLoaderUtil.getClientExtensionClassLoader();
        ReentrantReadWriteLock.ReadLock loadClass = lock.readLock();
        loadClass.lock();
        try {
            Class<?> clazz = loader.loadClass(className);
            return clazz;
        }
        finally {
            loadClass.unlock();
        }
    }

    private static ClassLoader getClientExtensionClassLoader() throws Exception {
        if (clientExtensionClassLoader == null) {
            ReentrantReadWriteLock.WriteLock updateClassLoader = lock.writeLock();
            updateClassLoader.lock();
            try {
                if (clientExtensionClassLoader == null) {
                    clientExtensionClassLoader = ExtensionClassLoaderUtil.createClientExtensionClassLoader();
                }
            }
            finally {
                updateClassLoader.unlock();
            }
            ExtensionClassLoaderUtil.monitorClassChange();
        }
        return clientExtensionClassLoader;
    }

    private static void monitorClassChange() throws IOException {
        if (folderMonitor != null && folderMonitor.isAlive()) {
            return;
        }
        Watcher classChangeWatcher = new Watcher(ApplicationProperties.getInstance().getProperty("clientClassesDirectory"), f -> f.getName().endsWith(".jar")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFolderContentsChanged(Path directory) {
                ReentrantReadWriteLock.WriteLock updateClassLoader = lock.writeLock();
                updateClassLoader.lock();
                try {
                    clientExtensionClassLoader = ExtensionClassLoaderUtil.createClientExtensionClassLoader();
                }
                catch (Exception e) {
                    log.error((Object)"Failed to create new class loader upon class change in folder, dynamic load classed failed", (Throwable)e);
                }
                finally {
                    updateClassLoader.unlock();
                }
            }
        };
        folderMonitor = new FolderMonitor(classChangeWatcher);
        folderMonitor.start();
    }

    private static ClientExtensionClassLoader createClientExtensionClassLoader() throws Exception {
        String dir = ApplicationProperties.getInstance().getProperty("clientClassesDirectory");
        ClassLoader parent = ExtensionClassLoaderUtil.class.getClassLoader();
        return new ClientExtensionClassLoader(dir, parent);
    }

    static {
        lock = new ReentrantReadWriteLock(true);
        log = Logger.getLogger(ExtensionClassLoaderUtil.class);
    }
}

