/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util.resource;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.IInternalResourceService;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class InternalResourceService
implements IInternalResourceService {
    private static final Logger LOGGER = Logger.getLogger(InternalResourceService.class);
    private Set<Long> resourceGroupIds;
    private Collection<String> systemIds;
    private ReadWriteLock updateLock = new ReentrantReadWriteLock();

    public InternalResourceService(String systemIds) {
        this.systemIds = this.getResourceTypes(systemIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsResource(long resourceGroupId) {
        Lock readLock = this.updateLock.readLock();
        readLock.lock();
        try {
            boolean bl = !this.resourceGroupIds.contains(resourceGroupId);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResourceQueuingDisabled(String systemId) {
        Lock readLock = this.updateLock.readLock();
        readLock.lock();
        try {
            boolean bl = this.systemIds.contains(systemId) || systemId.equals("04");
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public void resetResourceTypes(String resourceTypesId) {
        Lock writeLock = this.updateLock.writeLock();
        writeLock.lock();
        try {
            this.setSystemIds(this.getResourceTypes(resourceTypesId));
            this.stop();
            this.start();
        }
        finally {
            writeLock.unlock();
        }
    }

    public void start() {
        this.resourceGroupIds = new HashSet<Long>();
        for (String systemId : this.systemIds) {
            this.buildResourceGroupList(systemId);
        }
        this.addResourceGroups();
    }

    public void stop() {
        this.resourceGroupIds.clear();
    }

    public String getServiceName() {
        return "resource-internal-service";
    }

    public void add(long resourceGroupId) {
        LOGGER.debug((Object)("Adding resourceGroupId : " + resourceGroupId));
        this.resourceGroupIds.add(resourceGroupId);
    }

    public void remove(long resourceGroupId) {
        LOGGER.debug((Object)("Removing resourceGroupId : " + resourceGroupId));
        this.resourceGroupIds.remove(resourceGroupId);
    }

    public void setSystemIds(Collection<String> systemIds) {
        this.systemIds = systemIds;
    }

    private void buildResourceGroupList(String systemID) {
        ResourceManagement service = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        ResourceType resourceType = service.getResourceTypeBySystemId(systemID);
        if (resourceType == null) {
            LOGGER.warn((Object)("Resource type not found for system id: " + systemID));
            return;
        }
        long resourceTypeId = resourceType.getId();
        List resourceGroups = service.getResourceGroupsByResourceType(resourceTypeId);
        if (resourceGroups.isEmpty()) {
            LOGGER.warn((Object)("Resource groups not found for resource type id: " + resourceTypeId));
        }
        for (ResourceGroup g : resourceGroups) {
            LOGGER.debug((Object)("for " + systemID + " added " + g.getName()));
            this.resourceGroupIds.add(g.getId());
        }
    }

    private void addResourceGroups() {
        ResourceManagement resourceManager = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        List resourceGroups = resourceManager.getAllResourceGroups();
        for (ResourceGroup group : resourceGroups) {
            if (group.isAllocatable()) continue;
            this.resourceGroupIds.add(group.getId());
        }
    }

    private Collection<String> getResourceTypes(String property) {
        if (property == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(property.split(","));
    }
}

