/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.event;

import com.tandbergtv.workflow.core.event.ColleagueComparator;
import com.tandbergtv.workflow.core.event.EventNameUtils;
import com.tandbergtv.workflow.core.event.EventScheduler;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.IWorkerThreadAssigner;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public abstract class AbstractMediator
implements IMediator {
    protected Collection<WeakReference<IColleague>> references;
    private EventScheduler defaultExecutor;
    private ScheduledExecutorService reportScheduler;
    private ConcurrentHashMap<String, AtomicLong> counter = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> accumCounter = new ConcurrentHashMap();
    private Map<String, EventScheduler> executors = new ConcurrentHashMap<String, EventScheduler>();
    private Map<EventScheduler, String> executorsBinds = new ConcurrentHashMap<EventScheduler, String>();
    private int warningQueueSize = 10000;
    private int queueMointorInterval = 15;
    private static final Logger LOGGER = Logger.getLogger(AbstractMediator.class);

    protected AbstractMediator() {
        this.references = new PriorityQueue<WeakReference<IColleague>>(10, new ColleagueComparator());
        this.createExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(IColleague colleague) {
        Collection<WeakReference<IColleague>> collection = this.references;
        synchronized (collection) {
            this.references.add(new WeakReference<IColleague>(colleague));
        }
        LOGGER.debug((Object)("Added " + colleague.getColleagueName() + " [" + this.references.size() + "]"));
        for (WeakReference weakReference : this.references) {
            IColleague c = (IColleague)weakReference.get();
            if (c == null) continue;
            LOGGER.debug((Object)("Colleague " + c.getColleagueName() + ", priority " + (Object)((Object)c.getColleaguePriority())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(IColleague colleague) {
        Collection<WeakReference<IColleague>> collection = this.references;
        synchronized (collection) {
            Iterator<WeakReference<IColleague>> i = this.references.iterator();
            while (i.hasNext()) {
                WeakReference<IColleague> reference = i.next();
                IColleague c = (IColleague)reference.get();
                if (c != null && c != colleague) continue;
                i.remove();
                LOGGER.debug((Object)("Removed colleague " + colleague.getColleagueName()));
            }
        }
    }

    @Override
    public void sendAsync(WorkflowEvent event) {
        this.send(event, true);
    }

    @Override
    public void send(WorkflowEvent event) {
        this.send(event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(WorkflowEvent event, boolean isAsync) {
        ArrayList<WeakReference<IColleague>> copy = null;
        Iterator<WeakReference<IColleague>> i = null;
        Collection<WeakReference<IColleague>> collection = this.references;
        synchronized (collection) {
            copy = new ArrayList<WeakReference<IColleague>>();
            i = this.references.iterator();
            while (i.hasNext()) {
                WeakReference<IColleague> reference = i.next();
                IColleague colleague = (IColleague)reference.get();
                if (colleague == null) {
                    i.remove();
                    LOGGER.debug((Object)"Removed colleague");
                    continue;
                }
                copy.add(reference);
            }
        }
        for (WeakReference<IColleague> reference : copy) {
            IColleague colleague = (IColleague)reference.get();
            if (colleague == null) continue;
            if (isAsync) {
                this.sendAsync(colleague, event);
                continue;
            }
            this.send(colleague, event);
        }
    }

    private void sendAsync(IColleague colleague, WorkflowEvent event) {
        EventScheduler ses = this.getExecutor(event);
        String eventName = EventNameUtils.getEventName(event);
        this.calcuateInputEvent(eventName);
        ses.schedule(event, () -> {
            this.send(colleague, event);
            this.counter.get(EventNameUtils.getEventName(event)).decrementAndGet();
        });
    }

    private void calcuateInputEvent(String eventName) {
        this.counter.putIfAbsent(eventName, new AtomicLong());
        this.counter.get(eventName).incrementAndGet();
        this.accumCounter.putIfAbsent(eventName, new AtomicLong());
        long cur = this.accumCounter.get(eventName).incrementAndGet();
        if (cur == Long.MIN_VALUE) {
            this.accumCounter.get(eventName).set(1L);
        }
    }

    private void send(IColleague colleague, WorkflowEvent event) {
        try {
            long t = System.currentTimeMillis();
            event.setDeliverTime(t);
            colleague.receive(event);
            long delta = System.currentTimeMillis() - t;
            if (delta > 30000L) {
                String name = colleague.getColleagueName();
                String e = event.getClass().getSimpleName();
                LOGGER.warn((Object)(name + " took " + delta / 1000L + " sec for " + e));
            }
        }
        catch (Throwable t) {
            String msg = "Failed to send " + event.getClass().getSimpleName() + " to " + colleague.getColleagueName();
            LOGGER.error((Object)msg, t);
        }
    }

    private EventScheduler getExecutor(WorkflowEvent event) {
        String eventName = EventNameUtils.getEventName(event);
        return this.executors.containsKey(eventName) ? this.executors.get(eventName) : this.defaultExecutor;
    }

    private void createExecutor() {
        this.defaultExecutor = new EventScheduler("common", 2);
        this.reportScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("event-bus-reporter");
                t.setDaemon(true);
                return t;
            }
        });
        this.reportScheduler.scheduleAtFixedRate(() -> this.reportQueueInfo(), 10L, this.queueMointorInterval, TimeUnit.SECONDS);
    }

    @Override
    public void createEventScheduler(int threadPoolSize, IWorkerThreadAssigner assigner, Class<?> ... events) {
        String[] eventNames = EventNameUtils.toEventNames(events);
        this.createEventScheduler(threadPoolSize, assigner, eventNames);
    }

    public void createEventScheduler(int threadPoolSize, IWorkerThreadAssigner assigner, String ... eventNames) {
        EventScheduler executor = null;
        for (String name : eventNames) {
            if (!this.executors.containsKey(name)) continue;
            executor = this.executors.get(name);
            break;
        }
        if (executor == null) {
            executor = new EventScheduler(eventNames[0], threadPoolSize, assigner);
            LOGGER.info((Object)("Create Executor for event:" + eventNames[0]));
        }
        StringBuilder names = new StringBuilder();
        for (String name : eventNames) {
            this.executors.put(name, executor);
            if (names.length() > 0) {
                names.append(",");
            }
            names.append(name);
        }
        this.executorsBinds.put(executor, names.toString());
    }

    private void reportQueueInfo() {
        long totalQueueSize = this.defaultExecutor.count();
        StringBuilder sb = new StringBuilder(3000);
        sb.append("The default executor[" + this.defaultExecutor.getActiveCount() + " active threads] queue size -> " + totalQueueSize + "\n");
        for (Map.Entry<EventScheduler, String> entry : this.executorsBinds.entrySet()) {
            long size = entry.getKey().count();
            sb.append("[" + entry.getValue() + "][" + entry.getKey().getActiveCount() + " active threads] executor queue size -> " + size + "\n");
            totalQueueSize += size;
        }
        if (LOGGER.isDebugEnabled() || totalQueueSize > (long)this.warningQueueSize) {
            sb.append("counters by events:\n");
            for (Map.Entry<Object, Object> entry : this.counter.entrySet()) {
                sb.append("" + (String)entry.getKey() + ": current-> " + ((AtomicLong)entry.getValue()).get() + "  accumulate-> " + this.accumCounter.get(entry.getKey()).get() + "\n");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Events in event bus queue to deliver, total queue size: " + totalQueueSize + "\n" + sb));
            } else {
                LOGGER.warn((Object)("Too much events in event bus queue to deliver, total queue size: " + totalQueueSize + "\n" + sb));
            }
        }
    }
}

