/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.event;

import com.tandbergtv.workflow.core.event.EventNameUtils;
import com.tandbergtv.workflow.core.event.IWorkerThreadAssigner;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class EventScheduler {
    private String name;
    private ScheduledThreadPoolExecutor[] executors = null;
    private IWorkerThreadAssigner assigner;
    private static final Logger LOGGER = Logger.getLogger(EventScheduler.class);

    public EventScheduler(String name, int threadSize) {
        this(name, threadSize, null);
    }

    public EventScheduler(String name, int threadSize, IWorkerThreadAssigner assigner) {
        this.name = name;
        this.assigner = assigner;
        if (assigner == null) {
            this.executors = new ScheduledThreadPoolExecutor[]{new ScheduledThreadPoolExecutor(threadSize, new NamedThreadFactory())};
        } else {
            this.executors = new ScheduledThreadPoolExecutor[threadSize];
            for (int i = 0; i < this.executors.length; ++i) {
                this.executors[i] = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory(i + 1));
            }
        }
    }

    public void schedule(WorkflowEvent event, Runnable command) {
        ScheduledThreadPoolExecutor executor = this.selectExecutor(event);
        executor.schedule(command, 0L, TimeUnit.MILLISECONDS);
    }

    private ScheduledThreadPoolExecutor selectExecutor(WorkflowEvent event) {
        if (this.assigner == null) {
            return this.executors[0];
        }
        int index = this.assigner.assign(this.executors.length, event);
        if (index < 0 || index > this.executors.length - 1) {
            Random random = new Random();
            index = random.nextInt(this.executors.length);
            LOGGER.warn((Object)("Assigner assigned a invalid event thread #" + (index + 1) + " to event:" + event.toString() + ", use the random event thread #" + (index + 1)));
        }
        return this.executors[index];
    }

    public long count() {
        long total = 0L;
        for (ScheduledThreadPoolExecutor executor : this.executors) {
            total += (long)executor.getQueue().size();
        }
        return total;
    }

    public void shutdown() {
        for (ScheduledThreadPoolExecutor executor : this.executors) {
            executor.shutdown();
        }
    }

    public int getActiveCount() {
        int count = 0;
        for (ScheduledThreadPoolExecutor executor : this.executors) {
            count += executor.getActiveCount();
        }
        return count;
    }

    private class NamedThreadFactory
    implements ThreadFactory {
        final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private int index;
        final AtomicInteger threadNumber = new AtomicInteger(0);

        public NamedThreadFactory(int i) {
            this.index = i;
        }

        public NamedThreadFactory() {
            this.index = -1;
        }

        private int getThreadNumber() {
            return this.index > 0 ? this.index : this.threadNumber.incrementAndGet();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultFactory.newThread(r);
            thread.setName("event-bus-" + EventNameUtils.getEventSimpleName(EventScheduler.this.name) + "-" + this.getThreadNumber());
            thread.setDaemon(true);
            return thread;
        }
    }
}

