/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.event;

import java.util.EventObject;

public abstract class WorkflowEvent
extends EventObject {
    private static final long serialVersionUID = 243996022140736264L;
    private String topic;
    protected Throwable throwable;
    private static final String TOPIC_DEFAULT = "";
    protected boolean consume;
    private static final Object NO_SOURCE = new Object();
    private long createTime;
    private long deliverTime;

    protected WorkflowEvent() {
        this(NO_SOURCE, TOPIC_DEFAULT);
        this.createTime = System.currentTimeMillis();
    }

    protected WorkflowEvent(Object source) {
        this(source, TOPIC_DEFAULT);
        this.createTime = System.currentTimeMillis();
    }

    protected WorkflowEvent(Object source, Throwable t) {
        super(source);
        this.throwable = t;
        this.createTime = System.currentTimeMillis();
    }

    protected WorkflowEvent(Object source, String topic) {
        super(source);
        if (topic == null) {
            throw new IllegalArgumentException("Topic must not be null");
        }
        this.topic = topic;
        this.createTime = System.currentTimeMillis();
    }

    public String getTopic() {
        return this.topic;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public void setConsume(boolean consume) {
        this.consume = consume;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long receivedTime) {
        this.createTime = receivedTime;
    }

    public long getDeliverTime() {
        return this.deliverTime;
    }

    public void setDeliverTime(long deliverTime) {
        this.deliverTime = deliverTime;
    }
}

