/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tandbergtv.workflow.message.ArchiveMessage;
import java.util.List;
import java.util.Map;

public class ArchiveMessageChunk {
    public static final int MAX_ARCHIVE_WORKORDERS = 200;
    private Map<Long, ArchiveMessage> archiveMessageMap = Maps.newConcurrentMap();
    private Map<Long, ArchiveMessage> notInProgressMessageMap = Maps.newConcurrentMap();
    private Map<Long, ArchiveMessage> inProgressMessageMap = Maps.newConcurrentMap();
    private int maxsize = 200;

    public ArchiveMessageChunk(int maxsize) {
        this.maxsize = maxsize;
    }

    public int getMaxsize() {
        return this.maxsize;
    }

    public boolean isExit() {
        return this.archiveMessageMap.size() >= this.maxsize;
    }

    public void setMessage(ArchiveMessage message) {
        this.archiveMessageMap.put(message.getProcessId(), message);
        if (message.getInProgress().booleanValue()) {
            this.inProgressMessageMap.put(message.getProcessId(), message);
        } else {
            this.notInProgressMessageMap.put(message.getProcessId(), message);
        }
    }

    public boolean isEmpty() {
        return this.archiveMessageMap.isEmpty();
    }

    public Map<Long, ArchiveMessage> getArchiveMessageMap() {
        return this.archiveMessageMap;
    }

    public Map<Long, ArchiveMessage> getNotInProgressMessageMap() {
        return this.notInProgressMessageMap;
    }

    public Map<Long, ArchiveMessage> getInProgressMessageMap() {
        return this.inProgressMessageMap;
    }

    public List<ArchiveMessage> getArchiveMessageList() {
        return Lists.newArrayList(this.archiveMessageMap.values());
    }

    public List<Long> getInProgressMessageWoIds() {
        return Lists.newArrayList(this.inProgressMessageMap.keySet());
    }

    public List<Long> getNotInProgressMessageWoIds() {
        return Lists.newArrayList(this.notInProgressMessageMap.keySet());
    }
}

