/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.config;

import com.ericsson.cms.neptune.rabbitmq.service.RabbitConfiguration;
import com.ericsson.cms.neptune.rabbitmq.service.RabbitMQServiceArguments;
import com.ericsson.cms.neptune.rabbitmq.workflow.WorkflowExchangeType;
import com.ericsson.cms.neptune.rabbitmq.workflow.WorkflowQueueType;
import com.tandbergtv.workflow.message.config.WorkflowMessageConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Declarables;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WorkflowCreationConfiguration {
    public static final int RABBITMQ_MAX_PRIORITY = 79;
    public static final String EXCHANGE_NAME = WorkflowExchangeType.COMPLETION.toString();
    public static final String QUEUE_NAME = WorkflowQueueType.COMPLETION.toString();
    public static final String BYPASS_QUEUE_NAME = WorkflowQueueType.BY_PASS.toString();
    public static final String ALTERNATIVE_EXCHANGE_NAME = WorkflowExchangeType.ALTERNATIVE.toString();

    @Bean
    public RabbitMQServiceArguments rabbitMQComponentArguments() {
        RabbitMQServiceArguments arguments = new RabbitMQServiceArguments();
        arguments.setConnectionName("work-order-creation");
        return arguments;
    }

    @Bean
    public Declarables workOrderDeclarables() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("alternate-exchange", ALTERNATIVE_EXCHANGE_NAME);
        Exchange alternative = ExchangeBuilder.fanoutExchange((String)ALTERNATIVE_EXCHANGE_NAME).durable(false).build();
        Exchange completionExchange = ExchangeBuilder.directExchange((String)EXCHANGE_NAME).durable(false).withArguments(args).build();
        Map<String, Object> m = WorkflowCreationConfiguration.getQueueArgs();
        Queue completionQueue = QueueBuilder.durable((String)QUEUE_NAME).withArguments(m).build();
        Queue byPassQueue = QueueBuilder.durable((String)BYPASS_QUEUE_NAME).withArguments(m).build();
        Binding binding = BindingBuilder.bind((Queue)completionQueue).to(alternative).with("").noargs();
        return new Declarables(new Declarable[]{alternative, completionExchange, completionQueue, byPassQueue, binding});
    }

    @Bean
    public RabbitConfiguration.DefaultRabbitTemplateCustomizer defaultRabbitTemplateCustomizer() {
        return template -> template.setMessageConverter((MessageConverter)new WorkflowMessageConverter());
    }

    private static Map<String, Object> getQueueArgs() {
        HashMap<String, Object> m = new HashMap<String, Integer>();
        m.put("x-max-priority", 79);
        m = Collections.unmodifiableMap(m);
        return m;
    }
}

