/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.config;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.producer.MessageConvertor;
import com.tandbergtv.workflow.message.util.MarshalException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.SmartMessageConverter;

public class WorkflowMessageConverter
implements SmartMessageConverter {
    private MessageConvertor messageConvertor = new MessageConvertor();

    public Object fromMessage(Message message) throws MessageConversionException {
        return this.fromMessage(message, null);
    }

    public Object fromMessage(Message message, Object conversionHint) throws MessageConversionException {
        String body = new String(message.getBody(), StandardCharsets.UTF_8);
        try {
            return this.messageConvertor.asWorkflowMessage(body);
        }
        catch (Exception e) {
            throw new MessageConversionException("Failed to convert string to Workflow message.", (Throwable)e);
        }
    }

    public Message toMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        return this.toMessage(object, messageProperties, null);
    }

    public Message toMessage(Object object, MessageProperties messageProperties, Type genericType) throws MessageConversionException {
        if (object instanceof WorkflowMessage) {
            try {
                String body = this.messageConvertor.asString((WorkflowMessage)object);
                return new Message(body.getBytes(StandardCharsets.UTF_8), messageProperties);
            }
            catch (MarshalException | IOException e) {
                throw new MessageConversionException("Failed to convert the Workflow message to string. Cause:" + e.getMessage(), (Throwable)e);
            }
        }
        throw new MessageConversionException("Not support type:" + object.getClass());
    }
}

