/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.producer;

import com.ericsson.cms.neptune.rabbitmq.sender.IMessageSender;
import com.ericsson.cms.neptune.rabbitmq.sender.MessageSender;
import com.ericsson.cms.neptune.rabbitmq.service.RabbitMQService;
import com.ericsson.cms.neptune.rabbitmq.workflow.WorkflowExchangeType;
import com.ericsson.cms.neptune.rabbitmq.workflow.WorkflowQueueType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.message.ArchiveMessage;
import com.tandbergtv.workflow.message.producer.IArchiveMessageProducer;
import com.tandbergtv.workflow.message.producer.MessagePublishException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class ArchiveMessageProducer
implements IArchiveMessageProducer,
Service {
    public static final long DEFAULT_RETRY_MESSAGE_TTL = 1800L;
    public static final String ARCHIVE_MESSAGE_PRODUCER_SERVICE = "Archive-Workflow-Message-Producer";
    private static final String ARCHIVED_EXCHANGE_NAME = WorkflowExchangeType.ARCHIVED.toString();
    private static final String ARCHIVED_QUEUE_NAME = WorkflowQueueType.ARCHIVE.toString();
    private static final String ARCHIVED_RETRY_QUEUE_NAME = WorkflowQueueType.ARCHIVERETRY.toString();
    private RabbitMQService service;
    private IMessageSender messageSender;
    private long retryMessageTtl = 1800L;

    public ArchiveMessageProducer(RabbitMQService service) {
        this.service = service;
    }

    @Override
    public void publish(ArchiveMessage message) throws MessagePublishException {
        this.publish(message, Maps.newHashMap());
    }

    @Override
    public void publish(ArchiveMessage message, Map<String, Object> headers) throws MessagePublishException {
        ArrayList messages = Lists.newArrayList((Object[])new ArchiveMessage[]{message});
        this.batchPublish(messages, headers);
    }

    @Override
    public void publishToRetry(ArchiveMessage message) throws MessagePublishException {
        ArrayList messages = Lists.newArrayList((Object[])new ArchiveMessage[]{message});
        this.batchPublishToRetry(messages);
    }

    @Override
    public void publishToRetry(ArchiveMessage message, Map<String, Object> headers) throws MessagePublishException {
        ArrayList messages = Lists.newArrayList((Object[])new ArchiveMessage[]{message});
        this.batchPublishToRetry(messages, headers);
    }

    @Override
    public void batchPublish(List<ArchiveMessage> messages) throws MessagePublishException {
        this.batchPublish(messages, Maps.newHashMap());
    }

    @Override
    public void batchPublish(List<ArchiveMessage> messages, Map<String, Object> headers) throws MessagePublishException {
        if (messages.isEmpty()) {
            return;
        }
        try {
            boolean result = this.messageSender.sendWithSyncConfirm(ARCHIVED_EXCHANGE_NAME, ARCHIVED_QUEUE_NAME, messages, mp -> {
                mp.setHeaders(headers);
                return mp;
            });
            if (!result) {
                throw new MessagePublishException("Failed to deliver the archiving message");
            }
        }
        catch (MessagePublishException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagePublishException("Failed to deliver the archiving message", e);
        }
    }

    @Override
    public void batchPublishToRetry(List<ArchiveMessage> messages) throws MessagePublishException {
        this.batchPublishToRetry(messages, Maps.newHashMap());
    }

    @Override
    public void batchPublishToRetry(List<ArchiveMessage> messages, Map<String, Object> headers) throws MessagePublishException {
        if (messages.isEmpty()) {
            return;
        }
        try {
            boolean result = this.messageSender.sendWithSyncConfirm(ARCHIVED_EXCHANGE_NAME, ARCHIVED_RETRY_QUEUE_NAME, messages, mp -> {
                mp.setExpiration(String.valueOf(this.retryMessageTtl * 1000L));
                mp.setHeaders(headers);
                return mp;
            });
            if (!result) {
                throw new MessagePublishException("Failed to deliver the archiving message");
            }
        }
        catch (MessagePublishException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagePublishException("Failed to deliver the archiving message", e);
        }
    }

    @Override
    public void setRetryMessageTtl(long ttl) {
        Preconditions.checkArgument((ttl > 0L ? 1 : 0) != 0, (Object)"ttl must grater than 0");
        this.retryMessageTtl = ttl;
    }

    public String getServiceName() {
        return ARCHIVE_MESSAGE_PRODUCER_SERVICE;
    }

    public void start() {
        this.service.start();
        RabbitTemplate rabbitTemplate = this.service.getRabbitTemplate();
        this.messageSender = new MessageSender(rabbitTemplate);
    }

    public void stop() {
        this.service.stop();
    }
}

