/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.producer;

import com.ericsson.cms.neptune.rabbitmq.sender.IMessageSender;
import com.ericsson.cms.neptune.rabbitmq.sender.MessageSender;
import com.ericsson.cms.neptune.rabbitmq.service.RabbitMQService;
import com.ericsson.cms.neptune.rabbitmq.workflow.WorkflowExchangeType;
import com.google.common.collect.Maps;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.createid.CreateIDContextFactory;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.message.producer.IMessageProducer;
import com.tandbergtv.workflow.message.producer.MessagePublishException;
import com.tandbergtv.workflow.message.producer.MessageQueuePriorityMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class MessageProducer
implements IMessageProducer,
Service {
    public static final String MESSAGE_PRODUCER_SERVICE = "Workflow-Message-Producer-New";
    public static final WorkflowExchangeType DEFAULT_WORKORDER_EXCHANGE = WorkflowExchangeType.COMPLETION;
    private MessageQueuePriorityMapper priorityMapper;
    private volatile Boolean inited = false;
    private int waitForConfirmMilli;
    private RabbitMQService service;
    private IMessageSender messageSender;

    public MessageProducer(RabbitMQService service) {
        this.service = service;
        this.priorityMapper = new MessageQueuePriorityMapper();
    }

    @Override
    public String publish(ComponentType sourceComponet, WorkflowMessage message) throws MessagePublishException {
        String exchangeName = DEFAULT_WORKORDER_EXCHANGE.getValue();
        message.setPublishTime(System.currentTimeMillis());
        message.setSourceComponent(sourceComponet);
        String createId = message.getCreateId();
        if (StringUtils.isBlank((String)createId)) {
            createId = this.createUUID();
            this.addCreateId(createId, message);
        }
        String routingKey = message.getSourceComponent() != null ? message.getSourceComponent().toString() : "";
        try {
            Boolean confirmed = this.messageSender.sendWithSyncConfirm(exchangeName, routingKey, (Object)message, msg -> {
                int priority = this.priorityMapper.calcuRabbitMQPriority(sourceComponet, message);
                HashMap headers = Maps.newHashMap();
                headers.put("sourceComponent", sourceComponet.toString());
                msg.setPriority(Integer.valueOf(priority));
                msg.setHeaders((Map)headers);
                return msg;
            });
            if (!confirmed.booleanValue()) {
                throw new MessagePublishException("Failed to deliver the message");
            }
        }
        catch (MessagePublishException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagePublishException("Failed to deliver the message", e);
        }
        return createId;
    }

    @Override
    public void setWaitForConfirmMilli(int waitForConfirmMilli) {
        this.waitForConfirmMilli = waitForConfirmMilli;
    }

    private void addCreateId(String createId, WorkflowMessage message) {
        message.getCommand().addParameter("CreateID", createId);
    }

    private String createUUID() {
        return CreateIDContextFactory.createJavaUUIDGenerator().newUUID();
    }

    public boolean isInitialized() {
        return this.inited;
    }

    public void start() {
        this.service.start();
        RabbitTemplate rabbitTemplate = this.service.getRabbitTemplate();
        this.messageSender = new MessageSender(rabbitTemplate);
        if (this.waitForConfirmMilli > 0) {
            this.messageSender.setWaitForConfirmMilli(this.waitForConfirmMilli);
        }
        this.inited = true;
    }

    public void stop() {
        this.service.stop();
    }

    public String getServiceName() {
        return MESSAGE_PRODUCER_SERVICE;
    }
}

