/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.producer;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.message.producer.MessageQueuePriority;
import com.tandbergtv.workflow.message.producer.QueuePriority;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MessageQueuePriorityMapper {
    private static final Logger LOGGER = Logger.getLogger(MessageQueuePriorityMapper.class);

    public int calcuRabbitMQPriority(ComponentType sourceComponet, WorkflowMessage message) {
        MessageQueuePriority processPriority = this.getProcessPriority(message);
        int queuePriorityValue = this.getQueuePriorityValue(sourceComponet, message);
        LOGGER.debug((Object)("queue priority: " + queuePriorityValue + ", process priority: " + processPriority.getRabbitMqPriority()));
        return queuePriorityValue + processPriority.getRabbitMqPriority();
    }

    public boolean isHighestPriority(WorkflowMessage message) {
        ComponentType sourceComponet = message.getSourceComponent();
        if (sourceComponet == null) {
            return false;
        }
        return sourceComponet.getQueuePriority() == QueuePriority.HIGHEST;
    }

    private MessageQueuePriority getProcessPriority(WorkflowMessage message) {
        String priorityValue = message.getPriority();
        if (StringUtils.isBlank((String)priorityValue)) {
            return MessageQueuePriority.P10;
        }
        MessageQueuePriority priority = MessageQueuePriorityMapper.convertLegacyPriority(priorityValue);
        return priority;
    }

    private int getQueuePriorityValue(ComponentType sourceComponet, WorkflowMessage message) {
        int defaultQueuePriority = 0;
        try {
            String rabbitmqBucket = message.getRabbitmqBucket();
            if (!StringUtils.isBlank((String)rabbitmqBucket)) {
                return QueuePriority.valueOf(rabbitmqBucket.toUpperCase()).getRelativePriority();
            }
            if (sourceComponet != null) {
                return sourceComponet.getQueuePriority().getRelativePriority();
            }
            return defaultQueuePriority;
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to get queue priority", (Throwable)e);
            return defaultQueuePriority;
        }
    }

    public static MessageQueuePriority convertLegacyPriority(String priorityValue) {
        MessageQueuePriority priority;
        switch (priorityValue.toUpperCase()) {
            case "LOWEST": {
                priority = MessageQueuePriority.P20;
                break;
            }
            case "LOW": {
                priority = MessageQueuePriority.P15;
                break;
            }
            case "NORMAL": {
                priority = MessageQueuePriority.P10;
                break;
            }
            case "HIGH": {
                priority = MessageQueuePriority.P5;
                break;
            }
            case "HIGHEST": {
                priority = MessageQueuePriority.P1;
                break;
            }
            default: {
                priority = MessageQueuePriorityMapper.parsePriority(priorityValue);
            }
        }
        return priority;
    }

    private static MessageQueuePriority parsePriority(String priorityValue) {
        MessageQueuePriority priority = MessageQueuePriority.P10;
        try {
            priority = MessageQueuePriority.valueOf(priorityValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn((Object)("Failed to get priority - " + priorityValue + " is not a valid priority"), (Throwable)e);
        }
        return priority;
    }
}

