/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.producer;

import com.ericsson.cms.neptune.rabbitmq.service.RabbitMQService;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.config.WorkflowCreationConfiguration;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.message.producer.MessageProducer;
import com.tandbergtv.workflow.message.producer.MessagePublishException;
import com.tandbergtv.workflow.message.util.Assert;
import org.apache.log4j.Logger;

public class WorkflowCreationMessageDispatcher
implements Service {
    private static final int SECONDS_30 = 30000;
    public static final String SERVICE_NAME = "com.tandbergtv.workflow.message.producer.CreationMessageDispatcher";
    private volatile MessageProducer producer;
    private long timeout;
    private static final Logger LOGGER = Logger.getLogger(WorkflowCreationMessageDispatcher.class);
    private static WorkflowCreationMessageDispatcher instance = new WorkflowCreationMessageDispatcher();
    private volatile boolean isInited = false;

    public static WorkflowCreationMessageDispatcher getInstance() {
        return instance;
    }

    public void start() {
        this.start(30000L);
    }

    public void start(long timeout) {
        this.timeout = timeout;
        this.startProducer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProducer() {
        WorkflowCreationMessageDispatcher workflowCreationMessageDispatcher = this;
        synchronized (workflowCreationMessageDispatcher) {
            this.producer = this.lookupProducer();
            if (this.producer == null) {
                this.createProducer();
            }
            try {
                if (!this.producer.isInitialized()) {
                    LOGGER.info((Object)"Try to setup the connection to RabbitMQ");
                    this.producer.start();
                    this.isInited = true;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Failed to create the RabbitMQ connection", (Throwable)e);
                throw new IllegalStateException("Cannot create Message Producer due to " + e.getMessage());
            }
        }
    }

    private void createProducer() {
        try {
            RabbitMQService service = new RabbitMQService(new Class[]{WorkflowCreationConfiguration.class});
            this.producer = new MessageProducer(service);
            this.producer.setWaitForConfirmMilli((int)this.timeout);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to create the MessageProducer", (Throwable)e);
            throw new IllegalStateException("Cannot create Message Producer due to " + e.getMessage());
        }
    }

    private MessageProducer lookupProducer() {
        this.producer = (MessageProducer)ServiceRegistry.getDefault().lookup(MessageProducer.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("lookup the MessageProducer is " + this.producer));
        }
        return this.producer;
    }

    private void reSetupConnectionIfNotReady() throws MessagePublishException {
        if (!this.isInited) {
            this.startProducer();
        }
    }

    public void stop() {
        try {
            if (this.producer != null) {
                this.producer.stop();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to stop RabbitMQ Connection Service:", (Throwable)e);
        }
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public String sendCreationMessage(ComponentType type, WorkflowMessage message) throws MessagePublishException {
        Assert.notNull((Object)type, "The ComponentType cannot be null.");
        this.reSetupConnectionIfNotReady();
        return this.producer.publish(type, message);
    }

    public static String send(ComponentType type, WorkflowMessage message) throws MessagePublishException {
        long start = System.currentTimeMillis();
        String createdId = instance.sendCreationMessage(type, message);
        long cost = start - System.currentTimeMillis();
        LOGGER.debug((Object)("Message has been delivered in " + cost + " ms. The create id is :" + createdId));
        return createdId;
    }
}

