/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageCommandUtils {
    private static final String VALUE = "Value";
    private static final String NAME = "Name";
    private static final Logger logger = Logger.getLogger(MessageCommandUtils.class);

    private MessageCommandUtils() {
    }

    public static void addCreateId(Node command, String createId) {
        if (command == null || command.getAttributes().getNamedItem(NAME) == null) {
            logger.debug((Object)"It's not create command, cannot  add Create ID to it.");
            return;
        }
        Node commandName = command.getAttributes().getNamedItem(NAME);
        boolean isCreateCommand = StringUtils.equals((String)commandName.getNodeValue(), (String)"create");
        if (!isCreateCommand) {
            logger.debug((Object)"It's not create command, cannot  add Create ID to it.");
            return;
        }
        Node createIdNode = MessageCommandUtils.findCreateIdElement(command);
        if (createIdNode == null) {
            Element param = command.getOwnerDocument().createElementNS("", "CommandParameter");
            param.setAttribute(NAME, "CreateID");
            param.setAttribute(VALUE, createId);
            command.appendChild(param);
        }
    }

    public static String getCreatedId(Node cmd) {
        return MessageCommandUtils.getCmdAttributeValue(cmd, "CreateID");
    }

    public static String getCommandType(Node cmd) {
        if (cmd == null || cmd.getAttributes() == null) {
            return null;
        }
        Node namedItem = cmd.getAttributes().getNamedItem(NAME);
        return namedItem != null ? namedItem.getNodeValue() : null;
    }

    public static Node findCreateIdElement(Node command) {
        Node createIdNode = null;
        NodeList children = command.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String key;
            Node node = children.item(i);
            if (node.getAttributes() == null || node.getAttributes().getNamedItem(NAME) == null || !"CreateID".equals(key = node.getAttributes().getNamedItem(NAME).getNodeValue())) continue;
            createIdNode = node;
            break;
        }
        return createIdNode;
    }

    public static String getTemplateName(Node command) {
        return MessageCommandUtils.getCmdAttributeValue(command, "_template");
    }

    public static String getCmdAttributeValue(Node command, String paramName) {
        NodeList children = command.getChildNodes();
        String value = null;
        for (int i = 0; i < children.getLength(); ++i) {
            String key;
            Node node = children.item(i);
            if (node.getAttributes() == null || node.getAttributes().getNamedItem(NAME) == null || !StringUtils.equals((String)(key = node.getAttributes().getNamedItem(NAME).getNodeValue()), (String)paramName)) continue;
            value = node.getAttributes().getNamedItem(VALUE).getNodeValue();
            break;
        }
        return value;
    }

    public static Node getCmdNode(SOAPMessage msg) {
        try {
            NodeList commands = msg.getSOAPBody().getElementsByTagName("Command");
            if (commands.getLength() <= 0) {
                return null;
            }
            return commands.item(0);
        }
        catch (SOAPException e) {
            logger.debug((Object)("Fail to parse the work order creation msg" + msg), (Throwable)e);
            return null;
        }
    }

    public static String getMessageHeader(SOAPMessage msg) {
        try {
            NodeList tags = msg.getSOAPBody().getElementsByTagName("WFSMessage");
            if (tags.getLength() <= 0) {
                return null;
            }
            Node message = tags.item(0);
            return MessageCommandUtils.getAttributes(message, "UID", "MessageOrigin", "Type", "RequestKey");
        }
        catch (Exception e) {
            logger.debug((Object)("Fail to parse the work order creation msg" + msg), (Throwable)e);
            return null;
        }
    }

    private static String getAttributes(Node node, String ... attrNames) {
        StringBuilder msg = new StringBuilder(100);
        for (String name : attrNames) {
            Node attr = node.getAttributes().getNamedItem(name);
            if (attr == null) continue;
            if (msg.length() > 0) {
                msg.append(", ");
            }
            msg.append("" + name + "=" + attr.getNodeValue());
        }
        return msg.toString();
    }
}

