/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.core.Recorder;
import com.tandbergtv.workflow.monitor.internal.FileRecorderProperties;
import com.tandbergtv.workflow.monitor.internal.FileSystemdDeleted;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FileSystemRecorder
extends Recorder {
    private File root;
    private static final long CLEANUP_PERIOD = TimeUnit.MILLISECONDS.convert(6L, TimeUnit.HOURS);
    private static final long EXPIRE_PERIOD = TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS);
    private static final Logger LOGGER = Logger.getLogger(FileSystemRecorder.class);

    public FileSystemRecorder(ISchedulerService<Void> pool, String name, File root) {
        super(pool, name);
        this.root = root;
    }

    public File getRoot() {
        return this.root;
    }

    @Override
    public void record() {
        for (IObserver observer : this.observers) {
            List<Metric> metrics = observer.getMetrics();
            for (Metric metric : metrics) {
                File file = FileRecorderProperties.getFile(FileRecorderProperties.directoryFor(this.root, metric), metric);
                LOGGER.debug((Object)("File " + file.getAbsolutePath()));
                if (file.length() == 0L) {
                    this.writeHeader(file, metric);
                }
                this.update(file, metric);
            }
        }
    }

    @Override
    public void start() {
        super.start();
        this.pool.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    FileSystemdDeleted deleted = new FileSystemdDeleted(FileSystemRecorder.this.root, EXPIRE_PERIOD);
                    LOGGER.info((Object)"run FileSystemdDeleted");
                    for (IObserver observer : FileSystemRecorder.this.observers) {
                        LOGGER.debug((Object)("observer: " + observer.getMetricNames()));
                        deleted.deletedFiles(observer.getMetricNames());
                    }
                }
                catch (Exception t) {
                    Logger.getLogger(FileSystemRecorder.class).warn((Object)t.getMessage());
                }
            }
        }, 0L, CLEANUP_PERIOD);
    }

    private void update(File file, Metric metric) {
        try (FileOutputStream os = new FileOutputStream(file, true);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
            String time = String.valueOf(metric.getTime());
            String value = metric.getValue().toString();
            ((Writer)out).append(time).append('\t').append(value);
            ((Writer)out).append(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Cannot update " + file), (Throwable)e);
        }
    }

    private void writeHeader(File file, Metric metric) {
        try (FileOutputStream os = new FileOutputStream(file, true);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
            ((Writer)out).append("Time").append('\t').append(metric.getName());
            ((Writer)out).append(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Cannot write header " + file), (Throwable)e);
        }
    }
}

