/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.internal.FileRecorderProperties;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FileSystemdDeleted {
    private static final String CASHDOMAINTYPE = "Page";
    private final File root;
    private long period;
    private static final Logger LOGGER = Logger.getLogger(FileSystemdDeleted.class);

    public FileSystemdDeleted(File root, long period) {
        this.root = root;
        this.period = period;
    }

    public void deletedFiles(Collection<Metric> metrics) throws IOException {
        if (metrics == null || metrics.isEmpty()) {
            LOGGER.debug((Object)"deleteFile:metrics.isEmpty()");
            return;
        }
        File dir = FileRecorderProperties.directoryFor(this.root, metrics.iterator().next());
        if (dir.getName().equals(CASHDOMAINTYPE)) {
            for (File file : dir.listFiles()) {
                this.deleteOnlyByTime(file);
            }
        } else {
            Set<String> prefixes = this.getDomains(metrics);
            for (File file : dir.listFiles()) {
                this.filesToDelete(file, prefixes);
            }
        }
    }

    private void filesToDelete(File file, Collection<String> prefixes) {
        for (String prefix : prefixes) {
            if (!file.getName().startsWith(prefix) || System.currentTimeMillis() - file.lastModified() <= this.period) continue;
            this.deleteFile(file);
        }
    }

    private void deleteOnlyByTime(File file) {
        if (System.currentTimeMillis() - file.lastModified() > this.period) {
            this.deleteFile(file);
        }
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            LOGGER.warn((Object)("deletedFile Fail:" + file.getName()));
        } else {
            LOGGER.debug((Object)("deleteFile:" + file.getName()));
        }
    }

    private Set<String> getDomains(Collection<Metric> metrics) {
        HashSet<String> set = new HashSet<String>();
        for (Metric metric : metrics) {
            set.add(metric.getDomain());
            LOGGER.debug((Object)("getDomains:" + metric.getDomain()));
        }
        return set;
    }
}

