/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.util.WorkflowMessageBundleHelper;
import java.util.Date;
import java.util.ResourceBundle;

public class TokenError {
    private CustomToken token;
    private ErrorCategory category;
    private String message;
    private Date time;

    public TokenError(CustomToken token, ErrorCategory category, String message, Date time) {
        this.token = token;
        this.category = category;
        this.message = message;
        this.time = time;
    }

    public ErrorCategory getCategory() {
        return this.category;
    }

    public String getMessage() {
        if (this.category == ErrorCategory.CHILD_PROCESS_FAILED) {
            return ResourceBundle.getBundle("WorkflowProcessMessage").getString("subprocessFailed") + " " + this.token.getSubProcessInstance().getId();
        }
        if (this.category == ErrorCategory.TIMEOUT) {
            return ResourceBundle.getBundle("WorkflowProcessMessage").getString("timeOutError") + " " + this.token.getCurrentNode().getName();
        }
        if (this.category == ErrorCategory.INFINITE_LOOP) {
            return ResourceBundle.getBundle("WorkflowProcessMessage").getString("loopExceededError");
        }
        return this.message;
    }

    public String getLocalizedMessage() {
        if (this.category == ErrorCategory.CHILD_PROCESS_FAILED) {
            return WorkflowMessageBundleHelper.getWorkflowMessage("subprocessFailed") + " " + this.token.getSubProcessInstance().getId();
        }
        if (this.category == ErrorCategory.TIMEOUT) {
            return WorkflowMessageBundleHelper.getWorkflowMessage("timeOutError") + " " + this.token.getCurrentNode().getName();
        }
        if (this.category == ErrorCategory.INFINITE_LOOP) {
            return WorkflowMessageBundleHelper.getWorkflowMessage("loopExceededError");
        }
        return this.message;
    }

    public Date getTime() {
        return this.time;
    }
}

