/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.graph.exe.Transitions;
import com.tandbergtv.workflow.metrics.log.WorkorderMetricsLogger;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.logging.log.ProcessLog;

public abstract class AbstractTaskNode
extends TaskNode
implements ResourceGroupAware {
    private Long resourceGroupID = DEFAULT_RESOURCE_GROUP_ID;
    private static final Long DEFAULT_RESOURCE_GROUP_ID = -1L;
    private static final Logger LOGGER = Logger.getLogger(AbstractTaskNode.class);
    private static final long serialVersionUID = 36501193930537732L;

    public AbstractTaskNode() {
    }

    public AbstractTaskNode(String name) {
        super(name);
    }

    @Override
    public Long getResourceGroupID() {
        if (this.resourceGroupID.equals(DEFAULT_RESOURCE_GROUP_ID)) {
            return null;
        }
        return this.resourceGroupID;
    }

    @Override
    public void setResourceGroupID(Long resourceGroupID) {
        this.resourceGroupID = resourceGroupID == null ? DEFAULT_RESOURCE_GROUP_ID : resourceGroupID;
    }

    public Transition getDefaultLeavingTransition() {
        Transition leaving = Transitions.createDefaultLeavingTransition((Node)this);
        if (leaving != null) {
            return leaving;
        }
        return super.getDefaultLeavingTransition();
    }

    public void enter(ExecutionContext executionContext) {
        CustomToken token = (CustomToken)executionContext.getToken();
        token.setNode((Node)this);
        Date nodeEnter = new Date();
        Date previousNodeLeave = this.getLeave(token);
        WorkorderMetricsLogger.logNode(token, previousNodeLeave, new Date(), "transition");
        if (token.getStatus() != ProcessStatus.RUNNING) {
            throw new InvalidProcessStateException(token.toString());
        }
        LOGGER.info((Object)("[Process] " + token + " (" + this.name + ")"));
        this.fireEvent("node-enter", executionContext);
        token.acquire();
        token.setNodeEnter(nodeEnter);
        executionContext.setTransition(null);
        executionContext.setTransitionSource(null);
        this.execute(executionContext);
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        CustomToken token = (CustomToken)executionContext.getToken();
        Date nodeEnter = this.getEnter(token);
        WorkorderMetricsLogger.logNode(token, nodeEnter, new Date(), "leave");
        if (token.getStatus() != ProcessStatus.BUSY) {
            throw new InvalidProcessStateException(token.toString());
        }
        LOGGER.info((Object)("[Process] " + token + " (" + this.name + ")"));
        token.setNode((Node)this);
        executionContext.setTransition(transition);
        this.fireEvent("node-leave", executionContext);
        token.addLog((ProcessLog)new NodeLog((Node)this, this.getEnter(token), new Date()));
        executionContext.setTransitionSource((Node)this);
        token.release();
        transition.take(executionContext);
    }

    private Date getEnter(CustomToken token) {
        return token.getNodeEnter() != null ? token.getNodeEnter() : new Date();
    }

    private Date getLeave(CustomToken token) {
        return token.getNodeLeave() != null ? token.getNodeLeave() : new Date();
    }

    public void read(Element nodeElement, JpdlXmlReader jpdlXmlReader) {
        this.action = jpdlXmlReader.readSingleAction(nodeElement);
        super.read(nodeElement, jpdlXmlReader);
    }
}

