/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Pattern;

public enum Datatype {
    INVALID,
    INT,
    STRING,
    BOOLEAN,
    DATE,
    FILE,
    DESTINATION,
    DURATION,
    URL,
    LIST,
    CHAR,
    FLOAT,
    DOUBLE,
    LONG,
    BYTE,
    NULL;


    public static boolean isExpression(String initialValue, Datatype datatype) {
        ArrayList expressionSupportedType = Lists.newArrayList((Object[])new Datatype[]{INT, BYTE, LONG, DOUBLE, FLOAT, BOOLEAN, DATE});
        return expressionSupportedType.contains((Object)datatype) && Datatype.containExpression(initialValue);
    }

    private static boolean containExpression(String initialValue) {
        Pattern operatorPattern = Pattern.compile("([\\*\\/\\+\\-\\.])");
        Pattern arrayPattern = Pattern.compile("\\[\\w+\\]");
        return operatorPattern.matcher(initialValue).find() || arrayPattern.matcher(initialValue).find();
    }
}

