/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.entity;

import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.entity.SelectorKey;
import com.tandbergtv.workflow.core.entity.TemplateContentTypeEnum;
import com.tandbergtv.workflow.core.entity.WorkflowTemplateTypeId;
import com.tandbergtv.workflow.core.util.JsonObjectMapper;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class WorkflowTemplateDTO
implements Serializable {
    private static final long serialVersionUID = 9085905803260778553L;
    private long id;
    private String name;
    private int version;
    private WorkflowTemplateTypeId typeId;
    private String processDefinition;
    private String variables;
    private String nodeTimeouts;
    private TemplateContentTypeEnum contentType;
    private Set<SelectorKey> selectorKeys = Sets.newHashSet();
    private Date createDate;
    private Date updateDate;

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public WorkflowTemplateTypeId getTypeId() {
        return this.typeId;
    }

    public String getProcessDefinition() {
        return this.processDefinition;
    }

    public String getVariables() {
        return this.variables;
    }

    public String getNodeTimeouts() {
        return this.nodeTimeouts;
    }

    public Map<String, Object> getNodeTimeoutsMap() {
        if (StringUtils.isNotBlank((String)this.nodeTimeouts)) {
            return JsonObjectMapper.toMap(this.nodeTimeouts);
        }
        return Collections.emptyMap();
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setTypeId(WorkflowTemplateTypeId typeId) {
        this.typeId = typeId;
    }

    public void setProcessDefinition(String processDefinition) {
        this.processDefinition = processDefinition;
    }

    public void setVariables(String variables) {
        this.variables = variables;
    }

    public void setNodeTimeouts(String nodeTimeouts) {
        this.nodeTimeouts = nodeTimeouts;
    }

    public TemplateContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(TemplateContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public Set<SelectorKey> getSelectorKeys() {
        return Sets.newHashSet(this.selectorKeys);
    }

    public void addSelectorKey(SelectorKey selectorKey) {
        this.selectorKeys.add(selectorKey);
    }

    public void addSelectorKeys(List<SelectorKey> selectorKeys) {
        this.selectorKeys.addAll(selectorKeys);
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getFullName() {
        return this.name + " - v" + this.version;
    }

    public String toString() {
        return this.isNew() ? this.getFullName() : "[" + this.getId() + "] " + this.getFullName();
    }

    public boolean isNew() {
        return this.getId() <= 0L;
    }

    public boolean isActive() {
        return this.getTypeId() == WorkflowTemplateTypeId.ACTIVE;
    }
}

