/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.command.FailToken;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;

public class RetryExceptionHandler
implements ActionHandler {
    private String retry;
    private static final Logger LOGGER = Logger.getLogger(RetryExceptionHandler.class);
    private static final long serialVersionUID = 8929837220893895535L;

    public void execute(ExecutionContext context) throws Exception {
        CustomToken token = (CustomToken)context.getToken();
        this.resetVariable(token);
        if (!token.isResumeAfterFail()) {
            if (token.getRetryCount() < this.getCount()) {
                token.incrementRetryCount();
                token.setResumeAfterFail(true);
            } else {
                LOGGER.info((Object)(token + " exceeded " + this.retry + " retry attempts"));
                token.resetRetryCount();
            }
        }
        new FailToken().execute(context);
    }

    private void resetVariable(CustomToken token) {
        WorkflowProcess process = token.getProcessInstance();
        ContextInstance ci = process.getContextInstance();
        Node node = token.getCurrentNode();
        ci.deleteVariable("_current_resource_" + node.getName() + token.getId());
    }

    int getCount() {
        int count = 0;
        try {
            count = Integer.parseInt(this.retry);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return count;
    }
}

