/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.util.WorkflowMessageBundleHelper;
import java.util.Date;
import java.util.ResourceBundle;

public class TokenError {
    public static final String KEY_SUBPROCESS_FAILED = "token.error.subprocessFailed";
    public static final String KEY_TIMEOUT = "token.error.timeOutError";
    public static final String KEY_LOOP_EXCEEDED = "token.error.loopExceededError";
    private CustomToken token;
    private ErrorCategory category;
    private String message;
    private Date time;

    public TokenError(CustomToken token, ErrorCategory category, String message, Date time) {
        this.token = token;
        this.category = category;
        this.message = message;
        this.time = time;
    }

    public ErrorCategory getCategory() {
        return this.category;
    }

    public String getMessage() {
        ResourceBundle bundle = ResourceBundle.getBundle("WorkflowProcessMessage");
        if (this.category == ErrorCategory.CHILD_PROCESS_FAILED) {
            return bundle.getString(KEY_SUBPROCESS_FAILED) + " " + this.token.getSubProcessInstance().getId();
        }
        if (this.category == ErrorCategory.TIMEOUT) {
            return bundle.getString(KEY_TIMEOUT) + " " + this.token.getCurrentNode().getName();
        }
        if (this.category == ErrorCategory.INFINITE_LOOP) {
            return bundle.getString(KEY_LOOP_EXCEEDED);
        }
        return this.message;
    }

    public String getLocalizedMessage() {
        if (this.category == ErrorCategory.CHILD_PROCESS_FAILED) {
            return WorkflowMessageBundleHelper.getWorkflowMessage(KEY_SUBPROCESS_FAILED) + " " + this.token.getSubProcessInstance().getId();
        }
        if (this.category == ErrorCategory.TIMEOUT) {
            return WorkflowMessageBundleHelper.getWorkflowMessage(KEY_TIMEOUT) + " " + this.token.getCurrentNode().getName();
        }
        if (this.category == ErrorCategory.INFINITE_LOOP) {
            return WorkflowMessageBundleHelper.getWorkflowMessage(KEY_LOOP_EXCEEDED);
        }
        return this.message;
    }

    public String getMessageWithKey() {
        if (this.category == ErrorCategory.CHILD_PROCESS_FAILED) {
            return "token.error.subprocessFailed " + this.token.getSubProcessInstance().getId();
        }
        if (this.category == ErrorCategory.TIMEOUT) {
            return "token.error.timeOutError " + this.token.getCurrentNode().getName();
        }
        if (this.category == ErrorCategory.INFINITE_LOOP) {
            return KEY_LOOP_EXCEEDED;
        }
        return this.message;
    }

    public Date getTime() {
        return this.time;
    }
}

