/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph.exe;

import bsh.EvalError;
import bsh.Interpreter;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.graph.exe.ListVariableInstance;
import com.tandbergtv.workflow.core.util.VariableValidator;
import java.util.List;
import java.util.Map;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.context.exe.variableinstance.ByteArrayInstance;
import org.jbpm.context.exe.variableinstance.UnpersistableInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class ExecutionContext
extends org.jbpm.graph.exe.ExecutionContext {
    private static final ThreadLocal<Interpreter> INTERPRETER = new ThreadLocal<Interpreter>(){

        @Override
        protected Interpreter initialValue() {
            return new Interpreter();
        }
    };

    public ExecutionContext(Token token) {
        super(token);
    }

    public ExecutionContext(org.jbpm.graph.exe.ExecutionContext other) {
        super(other);
    }

    public Object getVariable(String name) {
        return ListVariableInstance.check(this, name) ? this.getListItem(name) : this.evaluate(name);
    }

    public void setVariable(String name, Object value) {
        VariableValidator.notEmptyString(name, "Variable name is an empty string");
        if (value != null) {
            VariableInstance variable = VariableInstance.createVariableInstance((Object)value);
            VariableValidator.notType(name, variable, UnpersistableInstance.class, ByteArrayInstance.class);
            if (value instanceof List) {
                List list = (List)value;
                for (Object itemValue : list) {
                    VariableValidator.notHugeString(itemValue, "List Variable " + name + " item ");
                }
            }
        }
        if (ListVariableInstance.check(this, name)) {
            ListVariableInstance list = ListVariableInstance.getListVariableInstance(this, name);
            int index = ListVariableInstance.index(this, name);
            list.set(index, value);
        } else {
            super.setVariable(name, value);
        }
    }

    public void setTaskInstance(TaskInstance taskInstance) {
        super.setTaskInstance(taskInstance);
        if (!this.validManualTask(taskInstance)) {
            return;
        }
        List variables = taskInstance.getTask().getTaskController().getVariableAccesses();
        if (variables == null) {
            return;
        }
        for (TaskVariable variable : variables) {
            if (!ListVariableInstance.check(this, variable.getVariableName())) continue;
            this.getListItem(variable.getVariableName());
        }
    }

    protected Object evaluate(String expression) {
        Object returnValue;
        VariableValidator.notEmptyValue(expression, "Missing variable name or expression");
        Map variables = this.getContextInstance().getVariables(this.token);
        if (variables.containsKey(expression)) {
            return super.getVariable(expression);
        }
        Interpreter i = INTERPRETER.get();
        try {
            for (Object key : variables.keySet()) {
                i.set((String)key, variables.get(key));
            }
            i.set("token", (Object)this.token);
            i.set("processInstance", (Object)this.token.getProcessInstance());
            i.set("_rootdir", (Object)System.getProperty("com.tandbergtv.cms.product.dir"));
            returnValue = i.eval(expression);
        }
        catch (Exception error) {
            throw new JbpmException("Error processing expression '" + expression + "'", (Throwable)error);
        }
        finally {
            try {
                for (Object key : variables.keySet()) {
                    i.unset((String)key);
                }
                i.unset("_rootdir");
                i.unset("token");
                i.unset("processInstance");
            }
            catch (EvalError e) {
                throw new JbpmException("Error unsetting Interpreter Variables", (Throwable)e);
            }
        }
        return returnValue;
    }

    private Object getListItem(String name) {
        ListVariableInstance list = ListVariableInstance.getListVariableInstance(this, name);
        int index = ListVariableInstance.index(this, name);
        return list.get(index);
    }

    private boolean validManualTask(TaskInstance ti) {
        if (!(this.token.getNode() instanceof ManualTaskNode)) {
            return false;
        }
        return ti != null && ti.getCreate() == null && ti.getTask() != null && ti.getTask().getTaskController() != null;
    }
}

