/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph.exe;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.instantiation.FieldInstantiator;
import org.xml.sax.SAXException;

public class FieldConfigInstantiator
extends FieldInstantiator {
    private static final Logger LOGGER = Logger.getLogger(FieldConfigInstantiator.class);

    public Object instantiate(Class clazz, String configuration) {
        Object newInstance = this.newInstance(clazz);
        if (configuration != null && !"".equals(configuration)) {
            List list = this.parseConfiguration(configuration).elements();
            for (Element propertyElement : list) {
                this.setPropertyValue(clazz, newInstance, propertyElement.getName(), propertyElement);
            }
        }
        return newInstance;
    }

    protected void setPropertyValue(Class clazz, Object newInstance, String propertyName, Element propertyElement) {
        try {
            Field f = this.findField(clazz, propertyName);
            if (f == null) {
                LOGGER.info((Object)("cannot find property[" + propertyName + "] in class[" + clazz + "], ignore it."));
                return;
            }
            f.setAccessible(true);
            f.set(newInstance, FieldConfigInstantiator.getValue(f.getType(), (Element)propertyElement));
        }
        catch (Exception e) {
            LOGGER.warn((Object)("couldn't parse set field '" + propertyName + "' to value '" + propertyElement.asXML() + "'"), (Throwable)e);
        }
    }

    private Field findField(Class clazz, String propertyName) throws NoSuchFieldException {
        Field f = null;
        if (clazz != null) {
            try {
                f = clazz.getDeclaredField(propertyName);
            }
            catch (NoSuchFieldException e) {
                f = this.findField(clazz.getSuperclass(), propertyName);
            }
        }
        return f;
    }

    public Element parseConfiguration(String configuration) {
        Element element = null;
        try {
            element = this.parseText("<action>" + configuration + "</action>").getRootElement();
        }
        catch (Exception e) {
            LOGGER.error((Object)("couldn't parse bean configuration : " + configuration), (Throwable)e);
            throw new JbpmException((Throwable)e);
        }
        return element;
    }

    private Document parseText(String text) throws DocumentException, SAXException {
        return DocumentHelper.parseText((String)text);
    }
}

