/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph.exe;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.exe.ExecutionContext;
import com.tandbergtv.workflow.core.util.VariableValidator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.graph.exe.Token;

public class ListVariableInstance
extends VariableInstance {
    private static final long serialVersionUID = 5567529337015616053L;
    private static Logger LOG = Logger.getLogger(ListVariableInstance.class);
    protected final String value = "LIST";
    public static final String START_TOKEN = "[";
    public static final String END_TOKEN = "]";
    public static final String EMPTY_LIST = "[]";
    public static final String SEPARATOR = ",";

    public boolean isStorable(Object value) {
        return value instanceof List;
    }

    public static boolean check(ExecutionContext context, String expression) {
        VariableValidator.notNull(expression, "List expression is null.");
        if (!expression.contains(START_TOKEN) && !expression.contains(END_TOKEN)) {
            return false;
        }
        VariableValidator.notBrokenListExpression(expression);
        String prefix = expression.substring(0, expression.indexOf(START_TOKEN));
        return ListVariableInstance.getVariableInstance(context, prefix) instanceof ListVariableInstance;
    }

    public static ListVariableInstance getListVariableInstance(ExecutionContext context, String expression) {
        if (!ListVariableInstance.check(context, expression)) {
            throw new IllegalArgumentException("Invalid list expression: " + expression);
        }
        String variableName = expression.substring(0, expression.indexOf(START_TOKEN));
        VariableInstance v = ListVariableInstance.getVariableInstance(context, variableName);
        return v instanceof ListVariableInstance ? (ListVariableInstance)v : null;
    }

    public static Integer index(ExecutionContext context, String expression) {
        if (!ListVariableInstance.check(context, expression)) {
            throw new IllegalArgumentException("Invalid list expression: " + expression);
        }
        ContextInstance ci = context.getToken().getProcessInstance().getContextInstance();
        return ListVariableInstance.index(ci.getTokenVariableMap(context.getToken()), expression);
    }

    public Object get(int index) {
        List<?> list = this.getListObject();
        VariableValidator.notOutRange(index, list, this.name);
        return list.get(index);
    }

    private List<?> getListObject() {
        return (List)this.getObject();
    }

    public void set(int index, Object value) {
        VariableValidator.notOutRange(index, this.getListObject(), this.name);
        List list = (List)this.getObject();
        list.set(index, value.toString());
        this.setObject(list);
    }

    protected Object getObject() {
        TreeMap<Integer, String> sorted = new TreeMap<Integer, String>();
        ContextInstance ci = this.token.getProcessInstance().getContextInstance();
        if (ci == null) {
            LOG.warn((Object)("Null context instance from token: " + this.token));
            return Lists.newArrayList();
        }
        TokenVariableMap map = ci.getTokenVariableMap(this.token);
        List<VariableInstance> copyOfVariableInstanceList = WorkflowProcess.getContextVariables(map);
        for (VariableInstance variable : copyOfVariableInstanceList) {
            if (!variable.getName().startsWith(this.name + START_TOKEN)) continue;
            Integer index = ListVariableInstance.index(map, variable.getName());
            String val = Objects.toString(variable.getValue(), "");
            sorted.put(index, val);
        }
        return new ArrayList(sorted.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setObject(Object value) {
        ContextInstance ci;
        VariableValidator.notNull(value, "List " + this.name + " cannot be null");
        ContextInstance contextInstance = ci = this.token.getProcessInstance().getContextInstance();
        synchronized (contextInstance) {
            this.removeListVariables(ci);
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                ci.setVariable(this.name + START_TOKEN + i + END_TOKEN, list.get(i), this.token);
            }
        }
        this.valueCache = null;
        this.isValueCached = false;
    }

    private void removeListVariables(ContextInstance ci) {
        TokenVariableMap map = ci.getTokenVariableMap(this.token);
        if (map != null && map.getVariableInstances() != null) {
            Map variables = map.getVariableInstances();
            Iterator i = variables.values().iterator();
            while (i.hasNext()) {
                VariableInstance variable = (VariableInstance)i.next();
                if (!variable.getName().startsWith(this.name + START_TOKEN)) continue;
                i.remove();
            }
        }
    }

    private static VariableInstance getVariableInstance(ExecutionContext context, String name) {
        Token token = context.getToken();
        ContextInstance ci = token.getProcessInstance().getContextInstance();
        TokenVariableMap map = ci.getTokenVariableMap(token);
        return map != null ? map.getVariableInstance(name) : null;
    }

    private static Integer index(TokenVariableMap tokenVariableMap, String name) {
        int end;
        int start = name.indexOf(START_TOKEN);
        String s = name.substring(start + 1, end = name.indexOf(END_TOKEN));
        Object value = tokenVariableMap.getVariable(s);
        return value instanceof Integer ? (Integer)value : Integer.valueOf(s);
    }
}

