/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.util;

import com.tandbergtv.workflow.core.util.Configuration;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class DateFormatter {
    public static final String JAVASCRIPT_DEFAULT_PATTERN = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    public static final String SHORT_DATE = "yyyy-MM-dd";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String INTERNAL_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String INTERNAL_ACTION_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    public static final String DATE_FORMAT_BETTER_HQL = "yyyy-mm-dd hh24:mi:ss";
    public static final String HOUR_FORMAT = "HH:mm:ss";
    public static final String LONG_HOUR_FORMAT = "dd'T'HH:mm:ss";
    public static final long MILL_SECONDS_ONE_DAY = 86400000L;
    public static final String DATE_FORMAT_KEY = "global_date_format";
    public static final String TIME_FORMAT_KEY = "global_time_format";
    private static String standardDisplayDateFormat = "yyyy-MM-dd HH:mm:ss";
    private static String standardDateFormat = "yyyy-MM-dd HH:mm:ss";
    private static String standardActionTimeFormat = "yyyy-MM-dd HH:mm:ss:SSS";

    private DateFormatter() {
    }

    public static String parseToDateString(String timestamp) {
        if (StringUtils.isEmpty((String)timestamp)) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(standardActionTimeFormat);
        return dateFormat.format(new Date(Long.valueOf(timestamp)));
    }

    public static String toStandardDate(long timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(standardDateFormat);
        return dateFormat.format(new Date(timestamp));
    }

    public static String toStandardDate(String timestampString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(standardDateFormat);
        return dateFormat.format(new Date(Configuration.toLong(timestampString, 1L)));
    }

    public static String toStandardDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(standardDateFormat);
        return dateFormat.format(date);
    }

    public static String toShortDate(Date date) {
        return DateFormatter.toDateString("yyyy-MM-dd", date);
    }

    public static String toStandardDisplayTime(Date date) {
        String dateFormat = DateFormatter.generateActionTimeDateFormat();
        return DateFormatter.toDateString(dateFormat, date);
    }

    static String generateActionTimeDateFormat() {
        if (standardDisplayDateFormat.contains("a")) {
            return StringUtils.replaceOnce((String)standardDisplayDateFormat, (String)"ss", (String)"ss:SSS");
        }
        return standardDisplayDateFormat + ":SSS";
    }

    public static String toStandardActionTime(Date date) {
        return DateFormatter.toDateString(standardActionTimeFormat, date);
    }

    public static String toDateString(String format, Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static Date toDate(String date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date fromShortDate(String source) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return dateFormat.parse(source);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date convertJavascriptTimeToJava(String javascriptdateString) {
        String dateWithZZString = StringUtils.split((String)javascriptdateString, (String)"(")[0];
        SimpleDateFormat dateFormat = new SimpleDateFormat(JAVASCRIPT_DEFAULT_PATTERN);
        try {
            return dateFormat.parse(dateWithZZString);
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    public static long toTimestamp(String sourceDate) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(standardActionTimeFormat);
        return dateFormat.parse(sourceDate).getTime();
    }

    public static synchronized void setStandardDisplayDateFormat(String standardDateFormat) {
        standardDisplayDateFormat = standardDateFormat;
    }
}

