/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.util;

import com.google.common.collect.Iterables;
import com.tandbergtv.workflow.core.util.SessionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.springframework.util.CollectionUtils;

public class HibernateTemplate {
    private static final Logger LOGGER = Logger.getLogger(HibernateTemplate.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long queryForLong(SessionFactory sessionFactory, String hsql, Object ... parameters) {
        Session session = SessionUtils.getSession(sessionFactory);
        try {
            org.hibernate.query.Query query = session.createQuery(hsql);
            if (ArrayUtils.isEmpty((Object[])parameters)) {
                for (int i = 0; i < parameters.length; ++i) {
                    query.setParameter(i, parameters[i]);
                }
            }
            Long l = HibernateTemplate.toLong(query.uniqueResult());
            return l;
        }
        finally {
            SessionUtils.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int queryForInt(SessionFactory sessionFactory, Query query) {
        Session session = SessionUtils.getSession(sessionFactory);
        try {
            int n = HibernateTemplate.toInteger(query.uniqueResult());
            return n;
        }
        finally {
            SessionUtils.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int sqlQueryForInt(SessionFactory sessionFactory, String sql, Object ... parameters) {
        Session session = SessionUtils.getSession(sessionFactory);
        try {
            NativeQuery query = session.createSQLQuery(sql);
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    query.setParameter(i, parameters[i]);
                }
            }
            int n = HibernateTemplate.toInteger(query.uniqueResult());
            return n;
        }
        finally {
            SessionUtils.closeSession(session);
        }
    }

    public static int toInteger(Object value) {
        int res = -1;
        if (value instanceof Number) {
            res = ((Number)value).intValue();
        } else if (value instanceof String) {
            try {
                res = Integer.parseInt("" + value);
            }
            catch (NumberFormatException e) {
                LOGGER.debug((Object)("Failed to parse the Integer value:" + value + " Error:" + e.getMessage()));
            }
        }
        return res;
    }

    public static int toInteger(List<?> queryResult) {
        if (CollectionUtils.isEmpty(queryResult)) {
            return -1;
        }
        Object value = Iterables.getFirst(queryResult, Object.class);
        return HibernateTemplate.toInteger(value);
    }

    public static long toLong(Object value) {
        long result = -1L;
        if (value instanceof Number) {
            result = ((Number)value).longValue();
        } else if (value instanceof String) {
            try {
                result = Long.parseLong("" + value);
            }
            catch (NumberFormatException e) {
                LOGGER.debug((Object)("Failed to parse the long value:" + value + " Error:" + e.getMessage()));
            }
        }
        return result;
    }

    public static String constructInParameters(int startIndex, int amount) {
        if (amount <= 0) {
            return "";
        }
        StringBuilder st = new StringBuilder();
        for (int i = 0; i < amount; ++i) {
            if (st.length() > 0) {
                st.append(",");
            }
            st.append("?").append(startIndex + i);
        }
        return "(" + st.toString() + ")";
    }

    public static String constructInValues(List<? extends Enum<?>> enumList) {
        if (CollectionUtils.isEmpty(enumList)) {
            return "";
        }
        ArrayList<Integer> ordinals = new ArrayList<Integer>();
        for (Enum<?> e : enumList) {
            ordinals.add(e.ordinal());
        }
        return StringUtils.join(ordinals, (String)",");
    }

    public static void constructInParameter(Query query, int startIndex, Collection<? extends Enum<?>> enumList) {
        if (CollectionUtils.isEmpty(enumList)) {
            return;
        }
        int start = startIndex;
        for (Enum<?> e : enumList) {
            query.setParameter(start, (Object)e.ordinal());
            ++start;
        }
    }
}

