/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.util;

import com.google.common.base.Stopwatch;
import com.tandbergtv.workflow.core.VariableHashMap;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.util.JsonObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.springframework.util.CollectionUtils;

public class Watch {
    private Watch() {
    }

    public static String cost(Stopwatch watch) {
        if (watch.isRunning()) {
            watch.stop();
        }
        return watch.elapsed(TimeUnit.MILLISECONDS) + " ms";
    }

    public static long time(Stopwatch watch) {
        if (watch.isRunning()) {
            watch.stop();
        }
        long cost = watch.elapsed(TimeUnit.MILLISECONDS);
        watch.reset();
        watch.start();
        return cost;
    }

    public static <K, V> String toString(Map<K, V> map) {
        if (CollectionUtils.isEmpty(map)) {
            return " Null Map";
        }
        StringBuilder sBuilder = new StringBuilder("{");
        for (Map.Entry<K, V> entry : map.entrySet()) {
            sBuilder.append(",");
            sBuilder.append(ReflectionToStringBuilder.toString(entry));
        }
        sBuilder.append("}");
        return sBuilder.toString();
    }

    public static String variablesToString(Map<String, Object> variables) {
        if (CollectionUtils.isEmpty(variables)) {
            return " Null Map";
        }
        StringBuilder sBuilder = new StringBuilder("{");
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            sBuilder.append(entry.getKey() + ":");
            sBuilder.append(entry + ", ");
        }
        sBuilder.append("}");
        return sBuilder.toString();
    }

    public static <V> String toString(List<V> list) {
        if (CollectionUtils.isEmpty(list)) {
            return " Null List";
        }
        StringBuilder sBuilder = new StringBuilder("[");
        for (V v : list) {
            sBuilder.append(",");
            sBuilder.append(ReflectionToStringBuilder.toString(v));
        }
        sBuilder.append("]");
        return sBuilder.toString();
    }

    public static String toString(WFSearchResult result) {
        return result != null ? result.getProcessId() + ">>" + ReflectionToStringBuilder.toString((Object)result) : null;
    }

    public static String toString(WorkflowProcess topProcess) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("\nTop level process: " + topProcess.toString());
        sb.append("\tbranch token(s): " + StringUtils.join(topProcess.getChildTokens(), (String)", "));
        sb.append("\tsubprocess(es): " + StringUtils.join(topProcess.getSubProcessInstances(), (String)", "));
        return sb.toString();
    }

    public static String toString(Object input) {
        if (input == null) {
            return "";
        }
        String className = input.getClass().getSimpleName();
        if (className.endsWith("[]")) {
            className = StringUtils.replace((String)className, (String)"[]", (String)" Array");
        }
        String valueStr = input instanceof String ? (StringUtils.isBlank((String)input.toString()) ? "\"\"" : input.toString()) : (input instanceof List ? JsonObjectMapper.toJsonString((List)List.class.cast(input)) : (input instanceof Map ? JsonObjectMapper.toJsonString((Map)Map.class.cast(input)) : (input instanceof VariableHashMap ? JsonObjectMapper.toJsonString((VariableHashMap)VariableHashMap.class.cast(input)) : (input.getClass().isArray() ? JsonObjectMapper.toJsonString(input) : Objects.toString(input, " Null value")))));
        return className + "(" + valueStr + ")";
    }
}

