/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.util;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.tandbergtv.neptune.i18n.common.MessageBundle;
import com.tandbergtv.neptune.i18n.service.I18nResourceService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang.LocaleUtils;
import org.apache.log4j.Logger;

public class WorkflowMessageBundleHelper {
    public static final String WORKFLOW_MESSAGE_BASENAME = "WorkflowProcessMessage";
    private static final String WORKFLOW_GROUP = "workflow";
    private static I18nResourceService i18nResourceService = (I18nResourceService)ServiceRegistry.getDefault().lookup(I18nResourceService.class);
    private static MessageBundle messageBundle = i18nResourceService.getMessageBundleInstance();
    private static Logger logger = Logger.getLogger(WorkflowMessageBundleHelper.class);

    private WorkflowMessageBundleHelper() {
    }

    public static String getWorkflowMessage(String localeKey) {
        String defaultValue = "";
        try {
            defaultValue = ResourceBundle.getBundle(WORKFLOW_MESSAGE_BASENAME).getString(localeKey);
        }
        catch (MissingResourceException ex) {
            logger.debug((Object)("Can not find the resource in workflow properties, key: " + localeKey + " file: " + WORKFLOW_MESSAGE_BASENAME), (Throwable)ex);
            return "";
        }
        return messageBundle.getMessageValue(localeKey, WORKFLOW_GROUP, defaultValue, WorkflowMessageBundleHelper.getCurrentLocale());
    }

    public static String getWorkflowMessage(String localeKey, String defaultValue, String locale) {
        return messageBundle.getMessageValue(localeKey, WORKFLOW_GROUP, defaultValue, LocaleUtils.toLocale((String)locale));
    }

    public static String getWorkflowMessageWithArguments(String localeKey, String defaultValue, String locale, Object ... arguments) {
        if (arguments == null || arguments.length < 1) {
            return WorkflowMessageBundleHelper.getWorkflowMessage(localeKey, defaultValue, locale);
        }
        return messageBundle.getMessageValue(localeKey, WORKFLOW_GROUP, MessageFormat.format(defaultValue, arguments), LocaleUtils.toLocale((String)locale), arguments);
    }

    public static Set<Locale> getAvailableLocales() {
        return i18nResourceService.getAvailableLocales();
    }

    private static Locale getCurrentLocale() {
        return I18nLocaleUtil.getThreadScopeLocale();
    }
}

