/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.metrics.log;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tandbergtv.workflow.metrics.log.MerticsConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class CustomFieldLoader {
    private static final String CUSTOM_MAPPING_FILE = "custom_wfs_mappings.json";
    private static final Logger LOGGER = Logger.getLogger(CustomFieldLoader.class);
    private List<String> customMappingFields = new ArrayList<String>();

    public CustomFieldLoader() {
        String file = Paths.get(System.getProperty("com.tandbergtv.cms.product.dir"), "conf", "workflow", CUSTOM_MAPPING_FILE).toString();
        List<String> defaultMappingFields = MerticsConstants.getDefaultmappingfields();
        this.loadFile(file, defaultMappingFields);
    }

    public List<String> getCustomMappingFields() {
        return this.customMappingFields;
    }

    public void loadFile(String file, List<String> defaultMappingFields) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.addMappingFields(inputStream, defaultMappingFields);
        }
        catch (IOException e) {
            LOGGER.debug((Object)(file + " is not found." + e.getMessage()));
        }
    }

    private void addMappingFields(InputStream is, List<String> defaultMappingFields) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode root = objectMapper.readTree(is);
            Iterator nodeIterator = root.findPath("properties").fieldNames();
            while (nodeIterator.hasNext()) {
                String field = (String)nodeIterator.next();
                if (!defaultMappingFields.contains(field) && !this.customMappingFields.contains(field)) {
                    this.customMappingFields.add(field);
                    LOGGER.debug((Object)("Added fieldName: " + field));
                    continue;
                }
                LOGGER.warn((Object)("The fieldName: " + field + " already exist."));
            }
        }
        catch (JsonProcessingException jpe) {
            LOGGER.error((Object)("Error occurred while processing " + is), (Throwable)jpe);
        }
        catch (IOException ioe) {
            LOGGER.error((Object)("Error occurred reading " + is), (Throwable)ioe);
        }
    }
}

