/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.metrics.log;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.TokenError;
import com.tandbergtv.workflow.metrics.log.CustomFieldLoader;
import com.tandbergtv.workflow.metrics.log.MerticsConstants;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.graph.exe.Token;

public class MetricsBuilder {
    public static final String LOCATION_VARIABLE = "_host_address";
    public static final String NODE_DURATION_METRICS_INDEX = "application-metrics.workflow.workorder_node";
    public static final String PROCESS_METRICS_INDEX = "application-metrics.workflow.workorder_process";
    private final List<String> customMappingFields = new CustomFieldLoader().getCustomMappingFields();

    public Map<String, Object> getNodeMetrics(CustomToken token, Date dateStart, Date dateEnd, String type) {
        HashMap<String, Object> fieldsMap = new HashMap<String, Object>();
        fieldsMap.put("index", NODE_DURATION_METRICS_INDEX);
        fieldsMap.put("type", type);
        fieldsMap.put("currentTask", token.getCurrentNode().getName());
        this.fillMetricsByProcess(token.getProcessInstance(), fieldsMap);
        this.fillTimeAndDurationMetrics(dateStart, dateEnd, fieldsMap);
        return fieldsMap;
    }

    private void fillTimeAndDurationMetrics(Date dateStart, Date dateEnd, Map<String, Object> fieldsMap) {
        fieldsMap.put("startTime", MerticsConstants.getStandardFormatedDate(dateStart));
        fieldsMap.put("endTime", this.getEndDate(dateEnd));
        fieldsMap.put("duration", this.getDuration(dateStart, dateEnd));
    }

    private void fillMetricsByProcess(WorkflowProcess process, Map<String, Object> fieldsMap) {
        fieldsMap.put("id", process.getId());
        fieldsMap.put("templateName", process.getProcessDefinition().getFullName());
        if (process.getContextInstance() != null) {
            fieldsMap.put(LOCATION_VARIABLE, process.getContextInstance().getVariable(LOCATION_VARIABLE));
        }
    }

    public Map<String, Object> getProcessMetrics(CustomToken token) {
        HashMap<String, Object> fieldsMap = new HashMap<String, Object>();
        WorkflowProcess process = token.getProcessInstance();
        fieldsMap.put("index", PROCESS_METRICS_INDEX);
        this.fillMetricsByProcess(process, fieldsMap);
        this.fillMetricsByToken(token, fieldsMap);
        this.fillTimeAndDurationMetrics(process.getStart(), process.getEnd(), fieldsMap);
        this.fillErrorMetrics(process.getStart(), token.getErrorDetails(), fieldsMap);
        fieldsMap.put("parentProcessId", this.getSuperProcessId(process));
        this.fillCustomMetrics(process, this.customMappingFields, fieldsMap);
        return fieldsMap;
    }

    private String getEndDate(Date endDate) {
        return MerticsConstants.getStandardFormatedDate(endDate == null ? new Date() : endDate);
    }

    private long getSuperProcessId(WorkflowProcess process) {
        CustomToken token = process.getSuperProcessToken();
        if (token != null && token.getProcessInstance() != null) {
            return token.getProcessInstance().getId();
        }
        return 0L;
    }

    private void fillMetricsByToken(CustomToken token, Map<String, Object> fieldsMap) {
        fieldsMap.put("adminStatus", (Object)token.getRequestedStatus());
        fieldsMap.put("status", (Object)token.getStatus());
        fieldsMap.put("currentTask", token.getCurrentNode().getName());
    }

    private void fillErrorMetrics(Date starTime, TokenError errorDetail, Map<String, Object> fieldsMap) {
        if (errorDetail == null) {
            return;
        }
        if (errorDetail.getTime() != null) {
            fieldsMap.put("endTime", MerticsConstants.getStandardFormatedDate(errorDetail.getTime()));
            fieldsMap.put("duration", this.getDuration(starTime, errorDetail.getTime()));
        }
        fieldsMap.put("errorType", (Object)errorDetail.getCategory());
        fieldsMap.put("errorComment", errorDetail.getMessage());
    }

    private long getDuration(Date dateStart, Date dateEnd) {
        if (dateEnd != null) {
            return dateEnd.getTime() - dateStart.getTime();
        }
        return System.currentTimeMillis() - dateStart.getTime();
    }

    public void fillCustomMetrics(WorkflowProcess process, List<String> customMappingFields, Map<String, Object> fieldsMap) {
        TokenVariableMap tMap = process.getContextInstance().getOrCreateTokenVariableMap((Token)process.getRootToken());
        LinkedHashSet tMapLocal = new LinkedHashSet(tMap.getVariables().keySet());
        for (String varName : tMapLocal) {
            if (!customMappingFields.contains(varName)) continue;
            fieldsMap.put(varName, tMap.getVariableInstance(varName).getValue());
        }
    }
}

