/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.metrics.log;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.metrics.log.MetricsBuilder;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class WorkorderMetricsLogger {
    private static final Logger LOGGER = Logger.getLogger(WorkorderMetricsLogger.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final MetricsBuilder metricsBuilder = new MetricsBuilder();

    public static void writeLog(Map<String, Object> metricsMap) {
        String loginfo = "";
        try {
            loginfo = mapper.writeValueAsString(metricsMap);
        }
        catch (JsonProcessingException e) {
            LOGGER.error((Object)("Format to Json error:" + e.getMessage()));
            return;
        }
        LOGGER.info((Object)loginfo);
    }

    public static void logProcess(CustomToken token) {
        WorkorderMetricsLogger.writeLog(metricsBuilder.getProcessMetrics(token));
    }

    public static void logNode(CustomToken token, Date dateStart, Date dateEnd, String type) {
        WorkorderMetricsLogger.writeLog(metricsBuilder.getNodeMetrics(token, dateStart, dateEnd, type));
    }

    public static boolean isEnabled() {
        return LOGGER.isInfoEnabled();
    }
}

