/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.ratelimiter;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalListeners;
import com.tandbergtv.workflow.process.ratelimiter.IOperatingSystemInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class OperatingSystemInfoLinuxProcImpl
implements IOperatingSystemInfo {
    private LoadingCache<String, Integer> cpuUsageCache;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private boolean supportedEnvironment = false;
    private static final long SAMPLING_TIME = 1000L;
    private static final String CPU_USAGE_KEY = "CPU_LOAD";
    private static final Logger LOGGER = Logger.getLogger(OperatingSystemInfoLinuxProcImpl.class);

    public OperatingSystemInfoLinuxProcImpl() {
        this.init();
        if (this.supportedEnvironment) {
            this.cpuUsageCache = this.buildCpuUsageCache();
        }
    }

    private void init() {
        if (!SystemUtils.IS_OS_LINUX) {
            return;
        }
        try {
            this.getSystemCpuLoadTicks();
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getMessage());
            return;
        }
        this.supportedEnvironment = true;
    }

    @Override
    public int getSystemCpuLoad() {
        int cpuLoad = 0;
        if (!this.supportedEnvironment) {
            return cpuLoad;
        }
        try {
            cpuLoad = (Integer)this.cpuUsageCache.get((Object)CPU_USAGE_KEY);
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getMessage());
        }
        return cpuLoad;
    }

    protected int getCpuLoad() {
        int cpuLoad = 0;
        try {
            cpuLoad = this.getCpuLoadByTicks(1000L);
        }
        catch (Exception e) {
            String msg = "Failed to get CPU load due to " + e.getMessage();
            LOGGER.warn((Object)msg);
            LOGGER.debug((Object)msg, (Throwable)e);
        }
        return cpuLoad;
    }

    private synchronized long[] getSystemCpuLoadTicks() throws IOException {
        File file = new File("/proc/stat");
        String procStat = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        String[] lines = procStat.split("[\\r\\n]+");
        String overallCpuStat = null;
        for (String line : lines) {
            if (!line.startsWith("cpu ")) continue;
            overallCpuStat = line;
        }
        Assert.notNull(overallCpuStat, (String)"Cannot find overall cpu information in /proc/stat file.");
        String[] stats = overallCpuStat.replaceFirst("cpu", "").trim().split("\\s+");
        Assert.isTrue((stats.length >= 8 ? 1 : 0) != 0, (String)"Not enough cpu stats, Linux kernel 2.6.11+ required.");
        long[] ticks = new long[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            ticks[i] = Long.parseLong(stats[i]);
        }
        return ticks;
    }

    private int getCpuLoadByTicks(long millis) throws IOException, InterruptedException {
        long[] prevTicks = this.getSystemCpuLoadTicks();
        Thread.sleep(millis);
        long[] ticks = this.getSystemCpuLoadTicks();
        long user = ticks[TickType.USER.getIndex()] - prevTicks[TickType.USER.getIndex()];
        long nice = ticks[TickType.NICE.getIndex()] - prevTicks[TickType.NICE.getIndex()];
        long sys = ticks[TickType.SYSTEM.getIndex()] - prevTicks[TickType.SYSTEM.getIndex()];
        long idle = ticks[TickType.IDLE.getIndex()] - prevTicks[TickType.IDLE.getIndex()];
        long iowait = ticks[TickType.IOWAIT.getIndex()] - prevTicks[TickType.IOWAIT.getIndex()];
        long irq = ticks[TickType.IRQ.getIndex()] - prevTicks[TickType.IRQ.getIndex()];
        long softirq = ticks[TickType.SOFTIRQ.getIndex()] - prevTicks[TickType.SOFTIRQ.getIndex()];
        long steal = ticks[TickType.STEAL.getIndex()] - prevTicks[TickType.STEAL.getIndex()];
        long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
        long idleCpu = idle + iowait;
        double value = totalCpu > 0L && idleCpu >= 0L ? (double)(totalCpu - idleCpu) / (double)totalCpu : 0.0;
        return (int)(value * 100.0);
    }

    private LoadingCache<String, Integer> buildCpuUsageCache() {
        CacheLoader<String, Integer> loader = new CacheLoader<String, Integer>(){

            public Integer load(String key) throws IOException, InterruptedException {
                return OperatingSystemInfoLinuxProcImpl.this.getCpuLoad();
            }
        };
        RemovalListener syncListener = removal -> {
            if (removal.wasEvicted()) {
                LOGGER.debug((Object)"Cached value removed!");
                int cpuLoad = this.getCpuLoad();
                this.cpuUsageCache.put((Object)CPU_USAGE_KEY, (Object)cpuLoad);
                LOGGER.debug((Object)("Update cpu load with new value: " + cpuLoad * 100 + "%."));
            }
        };
        RemovalListener removalListener = RemovalListeners.asynchronous((RemovalListener)syncListener, (Executor)this.executor);
        LoadingCache cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).removalListener(removalListener).build((CacheLoader)loader);
        return cache;
    }

    @Override
    public void close() {
        this.cpuUsageCache.cleanUp();
        this.executor.shutdown();
    }

    private static enum TickType {
        USER(0),
        NICE(1),
        SYSTEM(2),
        IDLE(3),
        IOWAIT(4),
        IRQ(5),
        SOFTIRQ(6),
        STEAL(7);

        private int index;

        private TickType(int value) {
            this.index = value;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

