/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.ratelimiter;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.tandbergtv.workflow.core.util.Reflection;
import com.tandbergtv.workflow.process.ratelimiter.IOperatingSystemInfo;
import com.tandbergtv.workflow.process.ratelimiter.NumberUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatingSystemInfoSunJMXImpl
implements IOperatingSystemInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatingSystemInfoSunJMXImpl.class);
    private static final String CPU_USAGE_KEY = "CPU_LOAD";
    private LoadingCache<String, Integer> cpuUsageCache;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private static volatile OperatingSystemMXBean osBean;
    private long sampleInterval = 10L;
    private static final int CPU_USAGE_PROVIDED_VALUE = 50;
    private volatile boolean inited = OperatingSystemInfoSunJMXImpl.initMXBean();

    public OperatingSystemInfoSunJMXImpl() {
        this.buildCpuUsageCache();
    }

    private static boolean initMXBean() {
        boolean flag = false;
        try {
            osBean = ManagementFactory.getOperatingSystemMXBean();
            flag = osBean.getClass().getName().startsWith("sun.management");
        }
        catch (Exception e) {
            String msg = "Cannot init the SUN JMX bean , unsupported JVM." + e.getMessage();
            LOGGER.error(msg);
            LOGGER.debug(msg, (Throwable)e);
        }
        return flag;
    }

    private void generateTrainningNumber() {
        Integer cpuLoad = 0;
        try {
            for (int i = 0; i < 10; ++i) {
                cpuLoad = this.getCpuLoadByMXBean();
                LOGGER.debug("Fetch CPU Usage:" + cpuLoad);
                Thread.sleep(20L);
            }
        }
        catch (Exception e) {
            LOGGER.warn("error happened when fetch cpu usage: ", (Throwable)e);
        }
        cpuLoad = this.loadCPUUsageSafely();
        this.cpuUsageCache.put((Object)CPU_USAGE_KEY, (Object)cpuLoad);
    }

    private void buildCpuUsageCache() {
        this.cpuUsageCache = CacheBuilder.newBuilder().maximumSize(10L).refreshAfterWrite(this.sampleInterval, TimeUnit.SECONDS).build((CacheLoader)new CPUCacheLoader());
        if (this.inited) {
            this.generateTrainningNumber();
        }
    }

    public void setSampleInterval(long sampleInterval) {
        this.sampleInterval = sampleInterval;
    }

    @Override
    public void close() {
        this.cpuUsageCache.cleanUp();
        this.executor.shutdown();
    }

    @Override
    public int getSystemCpuLoad() {
        int result = 0;
        try {
            result = (Integer)this.cpuUsageCache.get((Object)CPU_USAGE_KEY);
        }
        catch (ExecutionException e) {
            String msg = "Failed to load CPU usage from cache due to " + e.getMessage();
            LOGGER.warn(msg);
            LOGGER.debug(msg, (Throwable)e);
        }
        return result;
    }

    public int getCpuLoadByMXBean() {
        if (!this.inited) {
            return 0;
        }
        int usage = 0;
        try {
            usage = NumberUtils.getPercentage(this.fetchCPUUsage());
        }
        catch (Exception e) {
            String msg = "Failed to get CPU usage due to " + e.getMessage();
            LOGGER.warn(msg);
            LOGGER.debug(msg, (Throwable)e);
        }
        return usage;
    }

    private double fetchCPUUsage() {
        return (Double)Reflection.readCall((Object)osBean, (String)"com.sun.management.OperatingSystemMXBean", (String)"getSystemCpuLoad");
    }

    private boolean isCpuUsageValid(Integer cpuUsage) {
        return cpuUsage != null && cpuUsage > 0 && cpuUsage <= 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer loadCPUUsageSafely() {
        int cpuLoad = this.getCpuLoadByMXBean();
        int retryCount = 0;
        while (!this.isCpuUsageValid(cpuLoad) && retryCount < 10) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Failed to sleep for sampling CPU Usage");
            }
            finally {
                cpuLoad = this.getCpuLoadByMXBean();
                ++retryCount;
            }
        }
        if (!this.isCpuUsageValid(cpuLoad)) {
            cpuLoad = 50;
        }
        return cpuLoad;
    }

    class CPUCacheLoader
    extends CacheLoader<String, Integer> {
        CPUCacheLoader() {
        }

        public Integer load(String key) {
            return OperatingSystemInfoSunJMXImpl.this.loadCPUUsageSafely();
        }

        public ListenableFuture<Integer> reload(String key, final Integer oldCpuLoad) {
            ListenableFutureTask task = ListenableFutureTask.create((Callable)new Callable<Integer>(){

                @Override
                public Integer call() {
                    Integer cpuLoad = OperatingSystemInfoSunJMXImpl.this.getCpuLoadByMXBean();
                    if (!OperatingSystemInfoSunJMXImpl.this.isCpuUsageValid(cpuLoad)) {
                        LOGGER.debug("Cannot sample a valid CPU usage data, current value is " + cpuLoad + "%. we use 50% to instead it");
                        cpuLoad = OperatingSystemInfoSunJMXImpl.this.isCpuUsageValid(oldCpuLoad) ? oldCpuLoad : 50;
                    }
                    LOGGER.debug("Update cpu load with value: " + cpuLoad + "%.");
                    return cpuLoad;
                }
            });
            OperatingSystemInfoSunJMXImpl.this.executor.execute((Runnable)task);
            return task;
        }
    }
}

