/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.ratelimiter;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.message.producer.MessageQueuePriorityMapper;
import com.tandbergtv.workflow.process.ratelimiter.IActiveWorkOrderMonitor;
import com.tandbergtv.workflow.process.ratelimiter.IOperatingSystemInfo;
import com.tandbergtv.workflow.process.ratelimiter.IRateLimiter;
import com.tandbergtv.workflow.process.ratelimiter.NumberUtils;
import com.tandbergtv.workflow.process.ratelimiter.ThresholdSetting;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class SimpleRateLimiterImpl
implements IRateLimiter {
    public static final int DEFAULT_BUFFER_FOR_HIGEST_MSG = 40;
    private static final int MINUTES_2 = 120000;
    private Map<Class<?>, Object> context;
    private ThresholdSetting thresholdSetting = new ThresholdSetting();
    private static final Logger LOGGER = Logger.getLogger(SimpleRateLimiterImpl.class);
    private Lock lock = new ReentrantLock();
    private MessageQueuePriorityMapper messagePriorityMapper = new MessageQueuePriorityMapper();
    private volatile long lastLogTime = 0L;
    private int highestMessageBufferPercentage = 40;

    @Override
    public void setThresholds(Map<String, Object> props) {
        this.thresholdSetting.setThresholds(props);
    }

    @Override
    public ThresholdSetting getThresholdSetting() {
        return this.thresholdSetting;
    }

    @Override
    public void setContext(Map<Class<?>, Object> context) {
        this.context = context;
    }

    @Override
    public boolean reachThreshold() {
        Assert.notNull(this.context, (String)"Context cannot be null for current RateLimiter.");
        IActiveWorkOrderMonitor activeWOMonitor = this.getActiveWOMonitor();
        Assert.notNull((Object)activeWOMonitor, (String)("Cannot get " + IActiveWorkOrderMonitor.class.getName() + " Service from context!"));
        return this.isReachConcurrency(activeWOMonitor, this.getAllowActiveWOCount()) || this.isReachCpuLoad();
    }

    private int getAllowActiveWOCount() {
        return this.thresholdSetting.getAllowActiveWorkOrderCount();
    }

    private IActiveWorkOrderMonitor getActiveWOMonitor() {
        return (IActiveWorkOrderMonitor)this.context.get(IActiveWorkOrderMonitor.class);
    }

    private boolean isReachCpuLoad() {
        IOperatingSystemInfo operatingSystemInfo = (IOperatingSystemInfo)this.context.get(IOperatingSystemInfo.class);
        Assert.notNull((Object)operatingSystemInfo, (String)("Cannot get " + IOperatingSystemInfo.class.getName() + " Service from context!"));
        int cpuLoadThreshold = this.thresholdSetting.getCpuLoadThreshold();
        return this.isReachCpuLoad(operatingSystemInfo, cpuLoadThreshold);
    }

    boolean isReachCpuLoad(IOperatingSystemInfo operatingSystemInfo, int cpuLoadThreshold) {
        if (!ThresholdSetting.isValidCPUThreasHold(cpuLoadThreshold)) {
            LOGGER.warn((Object)("Invalid CPU usage threshold[" + cpuLoadThreshold + "%]  set,skip the check."));
            return false;
        }
        LOGGER.debug((Object)("Current system CPU usage: " + operatingSystemInfo.getSystemCpuLoad() + "%; CPU usage threshold: " + cpuLoadThreshold + "%."));
        if (operatingSystemInfo.getSystemCpuLoad() > cpuLoadThreshold) {
            LOGGER.info((Object)("Reach Limiter: System has exceeded cpu usage threshold. Threshold value: " + cpuLoadThreshold + "%; current CPU load: " + operatingSystemInfo.getSystemCpuLoad() + "%."));
            return true;
        }
        return false;
    }

    boolean isReachConcurrency(IActiveWorkOrderMonitor activeWOMonitor, int allowActiveWOCount) {
        boolean reached;
        LOGGER.debug((Object)("Current active Work order count: " + activeWOMonitor.getActiveWOCount() + "; allowed active WO count: " + allowActiveWOCount));
        boolean bl = reached = activeWOMonitor.getActiveWOCount() >= allowActiveWOCount;
        if (reached && LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Reach Limiter:Number of active work orders has reached the limiter. Maximum to allow: " + allowActiveWOCount + ", Current : " + activeWOMonitor.getActiveWOCount()));
            List<String> activeWOSet = activeWOMonitor.getActiveWOSet();
            LOGGER.debug((Object)(activeWOSet.size() + " Active Work Order in Monitor:\n" + StringUtils.join(activeWOSet, (String)",")));
        }
        return reached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requireExecution(WorkflowMessage message) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)message.getCreateId()), (String)"create id cannot be null");
        String messageInfo = "Message[" + message.getCreateId() + ", " + message.getSourceComponent() + "]";
        this.lock.lock();
        try {
            if (this.isByPassComponent(message)) {
                if (this.isReachCpuLoad()) {
                    LOGGER.debug((Object)(messageInfo + "  is bypass ratelimter type, but CPU usage reach threshold, can not get execution token."));
                    boolean bl = false;
                    return bl;
                }
                LOGGER.debug((Object)(messageInfo + "  is bypass ratelimter type, not count in Rate Limiter"));
                boolean bl = true;
                return bl;
            }
            if (this.reachThreshold()) {
                if (this.isInBufferForHighestMessage(message)) {
                    LOGGER.info((Object)("Reached Rate Limiter Limitation , use the reserved buffer for the highest priority " + messageInfo + " to execute."));
                } else {
                    this.logFailedToAssignDebugMessage(message);
                    boolean bl = false;
                    return bl;
                }
            }
            this.getActiveWOMonitor().addActiveWO(message.getCreateId());
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    boolean isInBufferForHighestMessage(WorkflowMessage message) {
        return this.messagePriorityMapper.isHighestPriority(message) && this.hasBufferForHighestMessage();
    }

    private void logFailedToAssignDebugMessage(WorkflowMessage message) {
        String msg = "Reach Limiter:Number of active work orders has reached the limiter. Maximum to allow: " + this.thresholdSetting.getAllowActiveWorkOrderCount() + ", current : " + this.getActiveWOCount();
        if (this.messagePriorityMapper.isHighestPriority(message)) {
            String noBufferMsg = "PERF:No buffer remained(AssignedActiveWOCount:" + this.getActiveWOCount() + ",AllowActiveWOCount:" + this.getAllowActiveWOCount() + ", bufferForHighestMessage:" + this.getReserveBufferCounterForHighestMessage() + "), failed to assign the execution token for the higest priority message ->" + message;
            LOGGER.debug((Object)noBufferMsg);
        }
        if (System.currentTimeMillis() - this.lastLogTime > 120000L) {
            LOGGER.info((Object)msg);
            this.lastLogTime = System.currentTimeMillis();
        } else {
            LOGGER.debug((Object)msg);
        }
    }

    private int getActiveWOCount() {
        return this.getActiveWOMonitor().getActiveWOCount();
    }

    private int getReserveBufferCounterForHighestMessage() {
        return NumberUtils.getPercentage(this.getAllowActiveWOCount(), this.highestMessageBufferPercentage);
    }

    private boolean isByPassComponent(WorkflowMessage message) {
        if (message.isByPassRateLimter()) {
            return true;
        }
        ComponentType type = message.getSourceComponent();
        return type != null && this.getByPassComponents().contains(type);
    }

    public void setHighestMessageBufferPercentage(int highestMessageBufferPercentage) {
        this.highestMessageBufferPercentage = highestMessageBufferPercentage;
    }

    @Override
    public List<ComponentType> getByPassComponents() {
        return this.thresholdSetting.getByPassComponents();
    }

    @Override
    public boolean hasBufferForHighestMessage() {
        return this.getAllowActiveWOCount() + this.getReserveBufferCounterForHighestMessage() - this.getActiveWOCount() > 0;
    }
}

