/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.ericsson.cms.neptune.cluster.service.IDistributedSchedulerService;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.internal.ActiveWorkOrderMonitorProvider;
import com.tandbergtv.workflow.driver.internal.CrashRecovery;
import com.tandbergtv.workflow.driver.internal.DynamicThreadPoolSchedule;
import com.tandbergtv.workflow.driver.internal.EventHandler;
import com.tandbergtv.workflow.driver.internal.UsageCalculator;
import com.tandbergtv.workflow.driver.internal.callable.CancelToken;
import com.tandbergtv.workflow.driver.internal.callable.DeleteToken;
import com.tandbergtv.workflow.driver.internal.callable.DequeToken;
import com.tandbergtv.workflow.driver.internal.callable.LocalRecoverToken;
import com.tandbergtv.workflow.driver.internal.callable.LocalResumeToken;
import com.tandbergtv.workflow.driver.internal.callable.LocalStartToken;
import com.tandbergtv.workflow.driver.internal.callable.OneShotTokenCallable;
import com.tandbergtv.workflow.driver.internal.callable.PauseToken;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import com.tandbergtv.workflow.driver.internal.monitor.CumulativeStatistics;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessStatistics;
import com.tandbergtv.workflow.driver.internal.monitor.Statistics;
import com.tandbergtv.workflow.driver.internal.monitor.TokenStatistics;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.monitor.IStatistics;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import com.tandbergtv.workflow.process.ratelimiter.IActiveWorkOrderMonitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Token;

public class ProcessManager
implements IProcessManagerService {
    private ISchedulerService<CustomToken> scheduler;
    private ISchedulerService<Void> globalScheduler;
    private IDistributedSchedulerService<CustomToken> recoverableDistributedScheduler;
    private IDistributedSchedulerService<CustomToken> distributedScheduler;
    private EventHandler eventhandler = new EventHandler();
    private IActiveWorkOrderMonitor activeWOMonitor = new ActiveWorkOrderMonitorProvider().create();
    private static final String SERVICE_NAME = "Process Manager";
    private boolean initialized;
    private Properties properties;
    private IStatistics statistics;
    public static final Long EMA_CALCULATION_PERIOD = 500L;
    static final int MAX_ERROR_PROCESSES = 1000;
    static final String ID = "id";
    static final Logger LOGGER = Logger.getLogger(ProcessManager.class);
    private UsageCalculator usageCalculator;

    public ProcessManager(Properties properties) {
        DefaultMediator.getInstance().register((IColleague)this.eventhandler);
        DefaultMediator.getInstance().register((IColleague)this.activeWOMonitor);
        this.globalScheduler = new Scheduler("process-runtime", 1, 1);
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".service");
        Configuration config = Configuration.build((ResourceBundle)bundle);
        double maxCreateRate = config.getDouble("max.create.rate");
        double factor = config.getDouble("history.factor");
        CumulativeStatistics cumulative = new CumulativeStatistics(maxCreateRate, factor, EMA_CALCULATION_PERIOD);
        ProcessStatistics current = new ProcessStatistics(this.getSearchService());
        TokenStatistics branches = new TokenStatistics(this.getTokenSearchService());
        this.statistics = new Statistics(current, cumulative, branches);
        int core = config.getInteger("scheduler.pool.size");
        core = Configuration.build((Properties)properties).getInteger("pool.size", core);
        this.scheduler = new DynamicThreadPoolSchedule("token-thread", core);
        this.properties = properties;
    }

    @Override
    public void setTokenThreadPoolSize(int max, int coreSizeRatioToMax) {
        ((DynamicThreadPoolSchedule)this.scheduler).setPoolSize(max, coreSizeRatioToMax);
    }

    @Override
    public IStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public IActiveWorkOrderMonitor getLocalActiveWOMonitor() {
        return this.activeWOMonitor;
    }

    protected IProcessCounter getCounter() {
        return (IProcessCounter)((Object)this.statistics.getCumulativeStatistics());
    }

    @Override
    public Future<CustomToken> start(CustomToken token) throws DriverException {
        return this.callAndForget(new LocalStartToken(token));
    }

    @Override
    public Future<CustomToken> startInLocalNode(CustomToken token) throws DriverException {
        return this.callAndForget(new LocalStartToken(token));
    }

    @Override
    public Future<CustomToken> pause(CustomToken token) {
        return this.call(new PauseToken(token));
    }

    @Override
    public Future<CustomToken> resume(CustomToken token) throws DriverException {
        return this.call(new LocalResumeToken(token));
    }

    @Override
    public Future<CustomToken> restart(final WorkflowProcess process) throws DriverException {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                WorkflowTemplate template = process.getProcessDefinition();
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                for (TaskVariable variable : template.getStartTaskVariables()) {
                    if (!variable.isRequired()) continue;
                    String name = variable.getVariableName();
                    Object value = process.getContextInstance().getVariable(name);
                    parameters.put(name, value);
                }
                IProcessFactory factory = (IProcessFactory)JbpmConfiguration.Configs.getObject((String)"jbpm.process.factory");
                CustomToken token = factory.create((ProcessDefinition)template, process.getPriority(), parameters).getRootToken();
                ProcessManager.this.start(token);
                ProcessManager.this.getCounter().restarted();
                return token;
            }
        });
    }

    @Override
    public Future<CustomToken> dequeue(CustomToken token) {
        return this.schedule(new DequeToken(token));
    }

    @Override
    public Future<CustomToken> recover(CustomToken token) {
        return this.call(new LocalRecoverToken(token));
    }

    @Override
    public Future<CustomToken> cancel(CustomToken token) {
        return this.call(new CancelToken(token));
    }

    @Override
    public Future<CustomToken> delete(WorkflowProcess process) throws DriverException {
        return this.call(new DeleteToken(process.getRootToken()));
    }

    @Override
    public Future<Void> recover() {
        return this.globalScheduler.schedule(this.getRecoveryJob());
    }

    @Override
    public Callable<Void> getRecoveryJob() {
        return new CrashRecovery();
    }

    @Override
    public void setPriority(WorkflowProcess process, ProcessPriority priority) {
        process.setPriority(priority);
        CustomToken rootToken = process.getRootToken();
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)this.createPriorityChangeEvent(process, (Token)rootToken));
        for (Token token : rootToken.getActiveChildTokens()) {
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)this.createPriorityChangeEvent(process, token));
        }
    }

    private WorkflowProcessEvent createPriorityChangeEvent(WorkflowProcess process, Token token) {
        return new WorkflowProcessEvent((Object)this, process, token, WorkflowProcessEventType.PRIORITY_CHANGED);
    }

    @Override
    public ISchedulerService<CustomToken> getScheduler() {
        return this.scheduler;
    }

    public void start() {
        if (this.initialized) {
            return;
        }
        LOGGER.debug((Object)"Starting process manager service...");
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
        this.globalScheduler.start();
        this.scheduler.start();
        this.globalScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                ProcessManager.this.getCounter().recalculateCreateRate();
            }
        }, 0L, EMA_CALCULATION_PERIOD.longValue());
        List<String> selectors = Arrays.asList(this.getProperty("com.tandbergtv.workflow.process.runtime.selectorKeys", "").split(","));
        this.usageCalculator = new UsageCalculator(this.getLicenseCreatedLimit(), selectors, this.properties);
        this.globalScheduler.schedule((Runnable)this.usageCalculator, 0L, TimeUnit.HOURS.toMillis(1L));
        this.initialized = true;
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTED));
        this.activeWOMonitor.start();
        LOGGER.info((Object)"Process manager service started");
    }

    @Override
    public void setLicenseCreatedLimit(int limit) {
        this.getProperties().setProperty("create.limit", String.valueOf(limit));
        this.usageCalculator.setCreatedLimit(limit);
        this.usageCalculator.calculate();
    }

    public int getLicenseCreatedLimit() {
        return Configuration.build((Properties)this.properties).getInteger("create.limit", Integer.MAX_VALUE);
    }

    public void stop() {
        if (!this.initialized) {
            return;
        }
        IMediator mediator = DefaultMediator.getInstance();
        mediator.unregister((IColleague)this.eventhandler);
        mediator.unregister((IColleague)this.activeWOMonitor);
        this.activeWOMonitor.stop();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPING));
        this.scheduler.stop();
        this.globalScheduler.stop();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
        this.initialized = false;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    private Future<CustomToken> schedule(Callable<CustomToken> callable) {
        return this.scheduler.schedule(callable);
    }

    private Future<CustomToken> call(TokenCallable callable) {
        return this.getRecoverableDistributedScheduler().schedule((Callable)((Object)callable));
    }

    private Future<CustomToken> callAndForget(OneShotTokenCallable callable) {
        return this.getDistributedScheduler().schedule((Callable)((Object)callable));
    }

    private IProcessSearchService getSearchService() {
        return (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
    }

    private ITokenSearchService getTokenSearchService() {
        return (ITokenSearchService)ServiceRegistry.getDefault().lookup(ITokenSearchService.class);
    }

    private String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    private IDistributedSchedulerService<CustomToken> getRecoverableDistributedScheduler() {
        if (this.recoverableDistributedScheduler == null) {
            this.recoverableDistributedScheduler = (IDistributedSchedulerService)ServiceRegistry.getDefault().lookup("distributed-scheduler");
        }
        return this.recoverableDistributedScheduler;
    }

    private IDistributedSchedulerService<CustomToken> getDistributedScheduler() {
        if (this.distributedScheduler == null) {
            this.distributedScheduler = (IDistributedSchedulerService)ServiceRegistry.getDefault().lookup("one-shot-distributed-scheduler");
        }
        return this.distributedScheduler;
    }
}

