/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import java.util.concurrent.Callable;

public class UpdateProcessCallable
extends TokenCallable {
    private String processNotesText;
    private ProcessPriority priority;
    private static final long serialVersionUID = -6904521560817110981L;

    public UpdateProcessCallable(CustomToken token, ProcessPriority priority, String processNotesText) {
        super(token);
        this.priority = priority;
        this.processNotesText = processNotesText;
    }

    @Override
    public CustomToken call() throws Exception {
        boolean priorityChanged;
        CustomToken token = this.findToken();
        WorkflowProcess process = token.getProcessInstance();
        boolean bl = priorityChanged = this.priority != process.getPriority();
        if (priorityChanged) {
            this.getProcessManagerService().setPriority(process, this.priority);
        } else {
            this.priority = null;
        }
        this.getProcessPersistenceService().update(process, this.priority, this.processNotesText);
        return token;
    }

    @Override
    protected Callable<CustomToken> innerCallable(CustomToken token) {
        throw new UnsupportedOperationException();
    }
}

