/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.internal.monitor.ActiveWorkOrderMonitor;
import com.tandbergtv.workflow.driver.internal.monitor.ICacheCleaner;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.message.util.ListUtils;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class InvalidWorkOrderCleaner
implements ICacheCleaner {
    private static final Logger LOGGER = Logger.getLogger(InvalidWorkOrderCleaner.class);
    private static final int POOL_SIZE = 5;
    private ScheduledExecutorService executor;
    private static final int MINUTES_60 = 3600;
    private long interval = 3600L;
    private ActiveWorkOrderMonitor activeWorkOrderMonitor;
    private List<ProcessStatus> stopProcessStatus = Lists.newArrayList((Object[])new ProcessStatus[]{ProcessStatus.COMPLETED, ProcessStatus.ERROR, ProcessStatus.PAUSED, ProcessStatus.CANCELLED});

    public InvalidWorkOrderCleaner(ActiveWorkOrderMonitor activeWorkOrderMonitor) {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("ActiveWOMonitor-CleanJob-%d").build();
        this.executor = Executors.newScheduledThreadPool(5, namedThreadFactory);
        this.setActiveWorkOrderMonitor(activeWorkOrderMonitor);
    }

    public void setActiveWorkOrderMonitor(ActiveWorkOrderMonitor activeWorkOrderMonitor) {
        this.activeWorkOrderMonitor = activeWorkOrderMonitor;
    }

    public void setExpiryTime(long expiryTimeInSeconds) {
        this.interval = expiryTimeInSeconds;
    }

    @Override
    public void start() {
        this.interval = Configuration.toLong((String)System.getProperty("invalidWoCleaner.schedule.interval"), (long)this.interval);
        LOGGER.debug((Object)("Start clean job to check the invalid work orders in monitor, inteval:" + this.interval + "seconds"));
        this.executor.scheduleAtFixedRate(() -> this.clean(), this.getExpircyMillSeconds(), this.getExpircyMillSeconds(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.executor.shutdown();
    }

    private void clean() {
        LOGGER.debug((Object)"Verifing work order status in Active WO Monitor");
        List<String> keys = this.findLongTimeLiveKeys();
        if (keys.isEmpty()) {
            LOGGER.debug((Object)"No possible invalid Work Orders found in Active WO Monitor");
            return;
        }
        if (keys.size() > 20) {
            LOGGER.info((Object)("Found " + keys.size() + " Work Orders live longer than " + this.interval + " seconds in monitor, try to verify if they have been completed but status are not sync to mointor. create id List: \n" + StringUtils.join((Object[])keys.toArray(), (String)",")));
        }
        List subs = ListUtils.split(keys, (int)20);
        for (List sub : subs) {
            this.executor.submit(() -> this.cleanPossibleInvalidWO(sub));
        }
    }

    private void cleanPossibleInvalidWO(List<String> sub) {
        IProcessSearchService service = ServiceLookup.findProcessSearchService();
        Assert.notNull((Object)service, (String)("Cannot get" + service.getServiceName() + "Service from ServiceRegistry!"));
        SearchCriteria searchCriteria = new SearchCriteria();
        ListParameter parameter = new ListParameter("createId", SearchType.STRING);
        for (String createId : sub) {
            parameter.addValues(new Object[]{createId});
        }
        searchCriteria.addParameter((SearchParameterBase)parameter);
        List<WFSearchResult> results = service.expressSearch(searchCriteria);
        if (results == null || results.isEmpty()) {
            LOGGER.debug((Object)("No Invalid Work orders found in [" + StringUtils.join(results, (String)",") + "]"));
            return;
        }
        for (WFSearchResult result : results) {
            ProcessStatus processStatus = result.getToken().getStatus();
            if (this.stopProcessStatus.contains(processStatus)) {
                LOGGER.info((Object)("Cleaned a completed WO from Monitor, create id:" + result.getCreateId() + ", status:" + processStatus));
                this.activeWorkOrderMonitor.removeActiveWO(result.getCreateId());
                continue;
            }
            if (processStatus != ProcessStatus.BRANCHED) continue;
            LOGGER.info((Object)("Found a long time live branched WO[" + result.getCreateId() + "] in monitor, cannot release it.you might need to cancel or retry it in GUI."));
        }
    }

    List<String> findLongTimeLiveKeys() {
        ArrayList keys = Lists.newArrayList();
        Map<String, Long> workOrders = this.activeWorkOrderMonitor.getActiveWoCache();
        for (Map.Entry<String, Long> entry : workOrders.entrySet()) {
            Long creationeTime = entry.getValue();
            if (creationeTime == null || !this.isExpircy(creationeTime)) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    boolean isExpircy(long creationTime) {
        return System.currentTimeMillis() - creationTime >= this.getExpircyMillSeconds();
    }

    long getExpircyMillSeconds() {
        return this.interval * 1000L;
    }
}

